/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dhis2.Dhis2Component;
import org.apache.camel.component.dhis2.Dhis2Configuration;
import org.apache.camel.component.dhis2.Dhis2Consumer;
import org.apache.camel.component.dhis2.Dhis2Producer;
import org.apache.camel.component.dhis2.api.Dhis2Delete;
import org.apache.camel.component.dhis2.api.Dhis2Get;
import org.apache.camel.component.dhis2.api.Dhis2Post;
import org.apache.camel.component.dhis2.api.Dhis2Put;
import org.apache.camel.component.dhis2.api.Dhis2ResourceTables;
import org.apache.camel.component.dhis2.internal.Dhis2ApiCollection;
import org.apache.camel.component.dhis2.internal.Dhis2ApiName;
import org.apache.camel.component.dhis2.internal.Dhis2PropertiesHelper;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;

@UriEndpoint(firstVersion="4.0.0", scheme="dhis2", title="DHIS2", syntax="dhis2:apiName/methodName", apiSyntax="apiName/methodName", category={Category.API})
public class Dhis2Endpoint
extends AbstractApiEndpoint<Dhis2ApiName, Dhis2Configuration>
implements EndpointServiceLocation {
    @UriParam
    private final Dhis2Configuration configuration;
    private Object apiProxy;

    public Dhis2Endpoint(String uri, Dhis2Component component, Dhis2ApiName apiName, String methodName, Dhis2Configuration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, Dhis2ApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        return new Dhis2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        Dhis2Consumer consumer = new Dhis2Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<Dhis2Configuration> getPropertiesHelper() {
        return Dhis2PropertiesHelper.getHelper(this.getCamelContext());
    }

    public String getServiceUrl() {
        return this.configuration.getBaseApiUrl();
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getUsername() != null) {
            return Map.of("username", this.configuration.getUsername());
        }
        return null;
    }

    public String getServiceProtocol() {
        return "http";
    }

    protected String getThreadProfileName() {
        return "CamelDhis2";
    }

    protected void afterConfigureProperties() {
        Dhis2Client dhis2Client = this.getClient();
        switch ((Dhis2ApiName)this.apiName) {
            case GET: {
                this.apiProxy = new Dhis2Get(dhis2Client);
                break;
            }
            case POST: {
                this.apiProxy = new Dhis2Post(dhis2Client);
                break;
            }
            case DELETE: {
                this.apiProxy = new Dhis2Delete(dhis2Client);
                break;
            }
            case PUT: {
                this.apiProxy = new Dhis2Put(dhis2Client);
                break;
            }
            case RESOURCE_TABLES: {
                this.apiProxy = new Dhis2ResourceTables(dhis2Client);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.apiProxy;
    }

    protected Dhis2Client getClient() {
        return ((Dhis2Component)this.getComponent()).getClient(this.configuration);
    }
}

