/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.common.ResourceType;
import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import com.myjeeva.digitalocean.pojo.Backups;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Droplets;
import com.myjeeva.digitalocean.pojo.Image;
import com.myjeeva.digitalocean.pojo.Kernels;
import com.myjeeva.digitalocean.pojo.Key;
import com.myjeeva.digitalocean.pojo.Neighbors;
import com.myjeeva.digitalocean.pojo.Region;
import com.myjeeva.digitalocean.pojo.Resource;
import com.myjeeva.digitalocean.pojo.Response;
import com.myjeeva.digitalocean.pojo.Snapshots;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.constants.DigitalOceanOperations;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanDropletsProducer
extends DigitalOceanProducer {
    private Integer dropletId;

    public DigitalOceanDropletsProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        DigitalOceanOperations op = this.determineOperation(exchange);
        if (op != DigitalOceanOperations.create && op != DigitalOceanOperations.list && op != DigitalOceanOperations.listAllNeighbors) {
            this.dropletId = (Integer)exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
            if (ObjectHelper.isEmpty((Object)this.dropletId)) {
                throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
            }
        }
        switch (op) {
            case create: {
                this.createDroplet(exchange);
                break;
            }
            case list: {
                this.getDroplets(exchange);
                break;
            }
            case delete: {
                this.deleteDroplet(exchange);
                break;
            }
            case get: {
                this.getDroplet(exchange);
                break;
            }
            case listActions: {
                this.getDropletActions(exchange);
                break;
            }
            case listSnapshots: {
                this.getDropletSnapshots(exchange);
                break;
            }
            case listKernels: {
                this.getDropletKernels(exchange);
                break;
            }
            case listBackups: {
                this.getDropletBackups(exchange);
                break;
            }
            case listNeighbors: {
                this.getDropletNeighbors(exchange);
                break;
            }
            case listAllNeighbors: {
                this.getAllDropletNeighbors(exchange);
                break;
            }
            case enableBackups: {
                this.enableDropletBackups(exchange);
                break;
            }
            case disableBackups: {
                this.disableDropletBackups(exchange);
                break;
            }
            case reboot: {
                this.rebootDroplet(exchange);
                break;
            }
            case powerCycle: {
                this.powerCycleDroplet(exchange);
                break;
            }
            case shutdown: {
                this.shutdownDroplet(exchange);
                break;
            }
            case powerOn: {
                this.powerOnDroplet(exchange);
                break;
            }
            case powerOff: {
                this.powerOffDroplet(exchange);
                break;
            }
            case restore: {
                this.restoreDroplet(exchange);
                break;
            }
            case resetPassword: {
                this.resetDropletPassword(exchange);
                break;
            }
            case resize: {
                this.resizeDroplet(exchange);
                break;
            }
            case rebuild: {
                this.rebuildDroplet(exchange);
                break;
            }
            case rename: {
                this.renameDroplet(exchange);
                break;
            }
            case changeKernel: {
                this.changeDropletKernel(exchange);
                break;
            }
            case enableIpv6: {
                this.enableDropletIpv6(exchange);
                break;
            }
            case enablePrivateNetworking: {
                this.enableDropletPrivateNetworking(exchange);
                break;
            }
            case takeSnapshot: {
                this.takeDropletSnapshot(exchange);
                break;
            }
            case tag: {
                this.tagDroplet(exchange);
                break;
            }
            case untag: {
                this.untagDroplet(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getDroplet(Exchange exchange) throws Exception {
        Droplet droplet = this.getEndpoint().getDigitalOceanClient().getDropletInfo(this.dropletId);
        LOG.trace("Droplet {}", (Object)droplet);
        exchange.getMessage().setBody((Object)droplet);
    }

    private void getDroplets(Exchange exchange) throws Exception {
        Droplets droplets = this.getEndpoint().getDigitalOceanClient().getAvailableDroplets(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Droplets : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), droplets.getDroplets()});
        exchange.getMessage().setBody((Object)droplets.getDroplets());
    }

    private void getDropletActions(Exchange exchange) throws Exception {
        Actions actions = this.getEndpoint().getDigitalOceanClient().getAvailableDropletActions(this.dropletId, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("Actions for Droplet {} : page {} / {} per page [{}] ", new Object[]{this.dropletId, this.configuration.getPage(), this.configuration.getPerPage(), actions.getActions()});
        exchange.getMessage().setBody((Object)actions.getActions());
    }

    private void getDropletKernels(Exchange exchange) throws Exception {
        Kernels kernels = this.getEndpoint().getDigitalOceanClient().getDropletKernels(this.dropletId, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("Kernels for Droplet {} : page {} / {} per page [{}] ", new Object[]{this.dropletId, this.configuration.getPage(), this.configuration.getPerPage(), kernels.getKernels()});
        exchange.getMessage().setBody((Object)kernels.getKernels());
    }

    private void getDropletBackups(Exchange exchange) throws Exception {
        Backups backups = this.getEndpoint().getDigitalOceanClient().getDropletBackups(this.dropletId, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("Backups for Droplet {} : page {} / {} per page [{}] ", new Object[]{this.dropletId, this.configuration.getPage(), this.configuration.getPerPage(), backups.getBackups()});
        exchange.getMessage().setBody((Object)backups.getBackups());
    }

    private void getDropletSnapshots(Exchange exchange) throws Exception {
        Snapshots snapshots = this.getEndpoint().getDigitalOceanClient().getDropletSnapshots(this.dropletId, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("Snapshots for Droplet {} : page {} / {} per page [{}] ", new Object[]{this.dropletId, this.configuration.getPage(), this.configuration.getPerPage(), snapshots.getSnapshots()});
        exchange.getMessage().setBody((Object)snapshots.getSnapshots());
    }

    private void getDropletNeighbors(Exchange exchange) throws Exception {
        Droplets droplets = this.getEndpoint().getDigitalOceanClient().getDropletNeighbors(this.dropletId, this.configuration.getPage());
        LOG.trace("Neighbors for Droplet {} : page {} [{}] ", new Object[]{this.dropletId, this.configuration.getPage(), droplets.getDroplets()});
        exchange.getMessage().setBody((Object)droplets.getDroplets());
    }

    private void getAllDropletNeighbors(Exchange exchange) throws Exception {
        Neighbors neighbors = this.getEndpoint().getDigitalOceanClient().getAllDropletNeighbors(this.configuration.getPage());
        LOG.trace("All Neighbors : page {} [{}] ", (Object)this.configuration.getPage(), (Object)neighbors.getNeighbors());
        exchange.getMessage().setBody((Object)neighbors.getNeighbors());
    }

    private void deleteDroplet(Exchange exchange) throws Exception {
        Delete delete = this.getEndpoint().getDigitalOceanClient().deleteDroplet(this.dropletId);
        LOG.trace("Delete Droplet {}", (Object)delete);
        exchange.getMessage().setBody((Object)delete);
    }

    private void createDroplet(Exchange exchange) throws Exception {
        Message in = exchange.getIn();
        Droplet droplet = new Droplet();
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanRegion"))) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        droplet.setRegion(new Region((String)in.getHeader("CamelDigitalOceanRegion", String.class)));
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletSize"))) {
            throw new IllegalArgumentException("CamelDigitalOceanDropletSize must be specified");
        }
        droplet.setSize((String)in.getHeader("CamelDigitalOceanDropletSize", String.class));
        if (!ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletImage"))) {
            throw new IllegalArgumentException("CamelDigitalOceanDropletImage must be specified");
        }
        droplet.setImage(new Image((String)in.getHeader("CamelDigitalOceanDropletImage", String.class)));
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletSSHKeys"))) {
            List keys = (List)exchange.getIn().getHeader("CamelDigitalOceanDropletSSHKeys");
            droplet.setKeys(keys.stream().map(Key::new).collect(Collectors.toList()));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletEnableBackups"))) {
            droplet.setEnableBackup((Boolean)in.getHeader("CamelDigitalOceanDropletEnableBackups", Boolean.class));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletEnableIpv6"))) {
            droplet.setEnableIpv6((Boolean)in.getHeader("CamelDigitalOceanDropletEnableIpv6", Boolean.class));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletEnablePrivateNetworking"))) {
            droplet.setEnablePrivateNetworking((Boolean)in.getHeader("CamelDigitalOceanDropletEnablePrivateNetworking", Boolean.class));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletUserData"))) {
            droplet.setUserData((String)in.getHeader("CamelDigitalOceanDropletUserData", String.class));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletVolumes"))) {
            droplet.setVolumeIds((List)exchange.getIn().getHeader("CamelDigitalOceanDropletVolumes"));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletTags"))) {
            droplet.setTags((List)exchange.getIn().getHeader("CamelDigitalOceanDropletTags"));
        }
        if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanNames"))) {
            droplet.setNames((List)in.getHeader("CamelDigitalOceanNames"));
            Droplets droplets = this.getEndpoint().getDigitalOceanClient().createDroplets(droplet);
            LOG.trace("Droplets created {}", (Object)droplets);
            exchange.getMessage().setBody((Object)droplets.getDroplets());
        } else if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanName"))) {
            droplet.setName((String)in.getHeader("CamelDigitalOceanName", String.class));
            droplet = this.getEndpoint().getDigitalOceanClient().createDroplet(droplet);
            LOG.trace("Droplet created {}", (Object)droplet);
            exchange.getMessage().setBody((Object)droplet);
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanNames or CamelDigitalOceanName must be specified");
        }
    }

    private void restoreDroplet(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanImageId"))) {
            throw new IllegalArgumentException("CamelDigitalOceanImageId must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().restoreDroplet(this.dropletId, (Integer)exchange.getIn().getHeader("CamelDigitalOceanImageId", Integer.class));
        LOG.trace("DropletAction Restore [{}] ", (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void resizeDroplet(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanDropletSize"))) {
            throw new IllegalArgumentException("CamelDigitalOceanDropletSize must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().resizeDroplet(this.dropletId, (String)exchange.getIn().getHeader("CamelDigitalOceanDropletSize", String.class));
        LOG.trace("DropletAction Resize [{}] ", (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void rebuildDroplet(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanImageId"))) {
            throw new IllegalArgumentException("CamelDigitalOceanImageId must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().rebuildDroplet(this.dropletId, (Integer)exchange.getIn().getHeader("CamelDigitalOceanImageId", Integer.class));
        LOG.trace("Rebuild Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void renameDroplet(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanName"))) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().renameDroplet(this.dropletId, (String)exchange.getIn().getHeader("CamelDigitalOceanName", String.class));
        LOG.trace("Rename Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void changeDropletKernel(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanKernelId"))) {
            throw new IllegalArgumentException("CamelDigitalOceanKernelId must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().changeDropletKernel(this.dropletId, (Integer)exchange.getIn().getHeader("CamelDigitalOceanKernelId", Integer.class));
        LOG.trace("Change Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void resetDropletPassword(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().resetDropletPassword(this.dropletId);
        LOG.trace("Reset password Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void powerOnDroplet(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().powerOnDroplet(this.dropletId);
        LOG.trace("Power on Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void powerOffDroplet(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().powerOffDroplet(this.dropletId);
        LOG.trace("Power off Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void shutdownDroplet(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().shutdownDroplet(this.dropletId);
        LOG.trace("Shutdown Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void powerCycleDroplet(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().powerCycleDroplet(this.dropletId);
        LOG.trace("Power cycle Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void enableDropletBackups(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().enableDropletBackups(this.dropletId);
        LOG.trace("Enable backups Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void disableDropletBackups(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().disableDropletBackups(this.dropletId);
        LOG.trace("Disable backups for Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void enableDropletIpv6(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().enableDropletIpv6(this.dropletId);
        LOG.trace("Enable IP v6 for Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void enableDropletPrivateNetworking(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().enableDropletPrivateNetworking(this.dropletId);
        LOG.trace("Enable private networking for Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void rebootDroplet(Exchange exchange) throws Exception {
        Action action = this.getEndpoint().getDigitalOceanClient().rebootDroplet(this.dropletId);
        LOG.trace("Reboot Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void takeDropletSnapshot(Exchange exchange) throws Exception {
        Action action = ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanName")) ? this.getEndpoint().getDigitalOceanClient().takeDropletSnapshot(this.dropletId, (String)exchange.getIn().getHeader("CamelDigitalOceanName", String.class)) : this.getEndpoint().getDigitalOceanClient().takeDropletSnapshot(this.dropletId);
        LOG.trace("Take Snapshot for Droplet {} : [{}] ", (Object)this.dropletId, (Object)action);
        exchange.getMessage().setBody((Object)action);
    }

    private void tagDroplet(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanName"))) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(1);
        resources.add(new Resource(this.dropletId.toString(), ResourceType.DROPLET));
        Response response = this.getEndpoint().getDigitalOceanClient().tagResources(this.dropletId.toString(), resources);
        LOG.trace("Tag Droplet {} : [{}] ", (Object)this.dropletId, (Object)response);
        exchange.getMessage().setBody((Object)response);
    }

    private void untagDroplet(Exchange exchange) throws Exception {
        if (ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelDigitalOceanName"))) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        ArrayList<Resource> resources = new ArrayList<Resource>(1);
        resources.add(new Resource(this.dropletId.toString(), ResourceType.DROPLET));
        Response response = this.getEndpoint().getDigitalOceanClient().untagResources(this.dropletId.toString(), resources);
        LOG.trace("Untag Droplet {} : [{}] ", (Object)this.dropletId, (Object)response);
        exchange.getMessage().setBody((Object)response);
    }
}

