/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.support.DefaultConsumer;

public class DirectConsumer
extends DefaultConsumer
implements ShutdownAware,
Suspendable {
    private final DirectComponent component;
    private final String key;

    public DirectConsumer(DirectEndpoint endpoint, Processor processor, String key) {
        super((Endpoint)endpoint, processor);
        this.component = (DirectComponent)endpoint.getComponent();
        this.key = key;
    }

    public DirectEndpoint getEndpoint() {
        return (DirectEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.component.addConsumer(this.key, this);
    }

    protected void doStop() throws Exception {
        this.component.removeConsumer(this.key, this);
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        this.component.removeConsumer(this.key, this);
    }

    protected void doResume() throws Exception {
        this.component.addConsumer(this.key, this);
    }

    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    public int getPendingExchangesSize() {
        return 0;
    }

    public void prepareShutdown(boolean suspendOnly, boolean forced) {
    }
}

