/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import org.apache.camel.Exchange;
import org.apache.camel.component.disruptor.MultipleConsumerSynchronizedExchange;
import org.apache.camel.component.disruptor.SingleConsumerSynchronizedExchange;
import org.apache.camel.component.disruptor.SynchronizedExchange;

public class ExchangeEvent {
    private SynchronizedExchange synchronizedExchange;

    public SynchronizedExchange getSynchronizedExchange() {
        return this.synchronizedExchange;
    }

    public void setExchange(Exchange exchange, int expectedConsumers) {
        this.synchronizedExchange = this.createSynchronizedExchange(exchange, expectedConsumers);
    }

    private SynchronizedExchange createSynchronizedExchange(Exchange exchange, int expectedConsumers) {
        if (expectedConsumers > 1) {
            return new MultipleConsumerSynchronizedExchange(exchange, expectedConsumers);
        }
        return new SingleConsumerSynchronizedExchange(exchange);
    }

    public String toString() {
        return "ExchangeEvent{exchange=" + this.synchronizedExchange.getExchange() + '}';
    }
}

