/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.disruptor;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Exchange;
import org.apache.camel.component.disruptor.AbstractSynchronizedExchange;
import org.apache.camel.support.ExchangeHelper;

public class MultipleConsumerSynchronizedExchange
extends AbstractSynchronizedExchange {
    private final int expectedConsumers;
    private final AtomicInteger processedConsumers = new AtomicInteger();
    private final AtomicBoolean resultHandled = new AtomicBoolean();

    public MultipleConsumerSynchronizedExchange(Exchange exchange, int expectedConsumers) {
        super(exchange);
        this.expectedConsumers = expectedConsumers;
        this.processedConsumers.set(0);
    }

    @Override
    public void consumed(Exchange result) {
        if (this.processedConsumers.incrementAndGet() == this.expectedConsumers || result.getException() != null && !this.resultHandled.getAndSet(true)) {
            if (result.getException() != null) {
                ExchangeHelper.copyResults((Exchange)this.getExchange(), (Exchange)result);
            }
            this.performSynchronization();
        }
    }

    @Override
    public Exchange cancelAndGetOriginalExchange() {
        this.resultHandled.set(true);
        return super.cancelAndGetOriginalExchange();
    }
}

