/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.audio;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.audio.Audio;
import ai.djl.modality.audio.AudioFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooAudioPredictor
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(ZooAudioPredictor.class);
    private final ZooModel<Audio, String> model;

    public ZooAudioPredictor(String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        Criteria criteria = Criteria.builder().optApplication(Application.Audio.ANY).setTypes(Audio.class, String.class).optArtifactId(artifactId).optProgress((Progress)new ProgressBar()).build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String result;
        Object body = exchange.getIn().getBody();
        if (body instanceof Audio) {
            result = this.predict(exchange, (Audio)exchange.getIn().getBody(Audio.class));
        } else if (body instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            result = this.predict(exchange, new ByteArrayInputStream(bytes));
        } else if (body instanceof File) {
            result = this.predict(exchange, (File)exchange.getIn().getBody(File.class));
        } else if (body instanceof InputStream) {
            result = this.predict(exchange, (InputStream)exchange.getIn().getBody(InputStream.class));
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be ai.djl.modality.audio.Audio, byte[], InputStream or File");
        }
        exchange.getIn().setBody((Object)result);
    }

    protected String predict(Exchange exchange, File input) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(input);
        try {
            Audio audio = AudioFactory.newInstance().fromInputStream((InputStream)fileInputStream);
            string = this.predict(exchange, audio);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("Couldn't transform input into a BufferedImage");
                throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
            }
        }
        ((InputStream)fileInputStream).close();
        return string;
    }

    protected String predict(Exchange exchange, InputStream input) {
        try {
            Audio audio = AudioFactory.newInstance().fromInputStream(input);
            return this.predict(exchange, audio);
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    protected String predict(Exchange exchange, Audio audio) {
        String string;
        block8: {
            exchange.getIn().setHeader("CamelDjlInput", (Object)audio);
            Predictor predictor = this.model.newPredictor();
            try {
                string = (String)predictor.predict((Object)audio);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return string;
    }
}

