/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.nlp;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class ZooQuestionAnswerPredictor
extends AbstractPredictor {
    private final ZooModel<QAInput, String> model;

    public ZooQuestionAnswerPredictor(String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        Criteria criteria = Criteria.builder().optApplication(Application.NLP.QUESTION_ANSWER).setTypes(QAInput.class, String.class).optArtifactId(artifactId).optProgress((Progress)new ProgressBar()).build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String result;
        Object body = exchange.getIn().getBody();
        if (body instanceof QAInput) {
            QAInput input = (QAInput)exchange.getIn().getBody(QAInput.class);
            result = this.predict(exchange, input);
        } else if (body instanceof String[]) {
            String[] strs = (String[])exchange.getIn().getBody(String[].class);
            if (strs.length < 2) {
                throw new RuntimeCamelException("Input String[] should have two elements");
            }
            QAInput input = new QAInput(strs[0], strs[1]);
            result = this.predict(exchange, input);
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be String[] or QAInput");
        }
        exchange.getIn().setBody((Object)result);
    }

    protected String predict(Exchange exchange, QAInput input) {
        String string;
        block8: {
            exchange.getIn().setHeader("CamelDjlInput", (Object)input);
            Predictor predictor = this.model.newPredictor();
            try {
                string = (String)predictor.predict((Object)input);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return string;
    }
}

