/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerOperation;
import org.apache.camel.component.docker.consumer.DockerEventsConsumer;
import org.apache.camel.component.docker.exception.DockerException;
import org.apache.camel.component.docker.producer.DockerProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="docker", syntax="docker:operation", consumerClass=DockerEventsConsumer.class, label="container,cloud,platform")
public class DockerEndpoint
extends DefaultEndpoint {
    @UriParam
    private DockerConfiguration configuration;

    public DockerEndpoint() {
    }

    public DockerEndpoint(String uri, DockerComponent component, DockerConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public DockerEndpoint(String endpointUri) {
        super(endpointUri);
    }

    public Producer createProducer() throws Exception {
        DockerOperation operation = this.configuration.getOperation();
        if (operation != null && operation.canProduce()) {
            return new DockerProducer(this);
        }
        throw new DockerException((Object)((Object)operation) + " is not a valid producer operation");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DockerOperation operation = this.configuration.getOperation();
        switch (operation) {
            case EVENTS: {
                return new DockerEventsConsumer(this, processor);
            }
        }
        throw new DockerException((Object)((Object)operation) + " is not a valid consumer operation");
    }

    public boolean isSingleton() {
        return true;
    }

    public DockerConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isLenientProperties() {
        return true;
    }
}

