/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker;

import java.util.HashMap;
import java.util.Map;

public enum DockerOperation {
    EVENTS("events", true, false, false, "CamelDockerInitialRange", Long.class),
    STATS("stats", true, false, false, "CamelDockerContainerId", Long.class),
    AUTH("auth", false, true, false, "CamelDockerUsername", String.class, "CamelDockerPassword", String.class, "CamelDockerEmail", String.class, "CamelDockerServerAddress", String.class),
    INFO("info", false, true, false, new Object[0]),
    PING("ping", false, true, false, new Object[0]),
    VERSION("version", false, true, false, new Object[0]),
    BUILD_IMAGE("imagebuild", false, true, true, "CamelDockerNoCache", Boolean.class, "CamelDockerRemove", Boolean.class, "CamelDockerQuiet", Boolean.class),
    CREATE_IMAGE("imagecreate", false, true, false, "CamelDockerRepository", String.class),
    INSPECT_IMAGE("imageinspect", false, true, false, "CamelDockerImageId", String.class, "CamelDockerNoPrune", Boolean.class, "CamelDockerForce", Boolean.class),
    LIST_IMAGES("imagelist", false, true, false, "CamelDockerFilter", String.class, "CamelDockerShowAll", Boolean.class),
    PULL_IMAGE("imagepull", false, true, true, "CamelDockerRegistry", String.class, "CamelDockerTag", String.class, "CamelDockerRepository", String.class),
    PUSH_IMAGE("imagepush", false, true, true, "CamelDockerName", String.class, "CamelDockerTag", String.class),
    REMOVE_IMAGE("imageremove", false, true, false, "CamelDockerImageId", String.class, "CamelDockerForce", Boolean.class, "CamelDockerNoPrune", String.class),
    SEARCH_IMAGES("imagesearch", false, true, false, "CamelDockerTerm", String.class),
    TAG_IMAGE("imagetag", false, true, false, "CamelDockerForce", Boolean.class, "CamelDockerImageId", String.class, "CamelDockerRepository", String.class),
    ATTACH_CONTAINER("containerattach", false, true, true, "CamelDockerContainerId", String.class, "CamelDockerFollowStream", Boolean.class, "CamelDockerLogs", Boolean.class, "CamelDockerStdOut", Boolean.class, "CamelDockerStdErr", Boolean.class, "CamelDockerTimestamps", Boolean.class),
    COMMIT_CONTAINER("containercommit", false, true, false, "CamelDockerAttachStdErr", Boolean.class, "CamelDockerAttachStdIn", Boolean.class, "CamelDockerAttachStdOut", Boolean.class, "CamelDockerAuthor", String.class, "CamelDockerCmd", String.class, "CamelDockerContainerId", String.class, "CamelDockerDisableNetwork", String.class, "CamelDockerEnv", String.class, "CamelDockerExposedPorts", String.class, "CamelDockerHostname", String.class, "CamelDockerMemory", Integer.class, "CamelDockerMemorySwap", Integer.class, "CamelDockerMessage", String.class, "CamelDockerOpenStdIn", Boolean.class, "CamelDockerPause", Boolean.class, "CamelDockerPortSpecs", String.class, "CamelDockerRepository", String.class, "CamelDockerStdInOnce", Boolean.class, "CamelDockerTag", String.class, "CamelDockerTty", Boolean.class, "CamelDockerUser", String.class, "CamelDockerVolumes", String.class, "CamelDockerWorkingDir", String.class),
    COPY_FILE_CONTAINER("containercopyfile", false, true, false, "CamelDockerContainerId", String.class, "CamelDockerHostPath", String.class, "CamelDockerResource", String.class),
    CREATE_CONTAINER("containercreate", false, true, false, "CamelDockerAttachStdErr", Boolean.class, "CamelDockerAttachStdIn", Boolean.class, "CamelDockerAttachStdOut", Boolean.class, "CamelDockerCapAdd", String.class, "CamelDockerCapDrop", String.class, "CamelDockerCmd", String.class, "CamelDockerCpuShares", Integer.class, "CamelDockerDisableNetwork", Boolean.class, "CamelDockerDns", String.class, "CamelDockerDomainName", String.class, "CamelDockerEntryPoint", String.class, "CamelDockerEnv", String.class, "CamelDockerExposedPorts", String.class, "CamelDockerHostConfig", String.class, "CamelDockerHostname", String.class, "CamelDockerImage", String.class, "CamelDockerName", String.class, "CamelDockerPortSpecs", String.class, "CamelDockerStdInOpen", Boolean.class, "CamelDockerStdInOnce", Boolean.class, "CamelDockerTty", Boolean.class, "CamelDockerUser", String.class, "CamelDockerVolumes", String.class, "CamelDockerVolumesFrom", String.class, "CamelDockerWorkingDir", String.class),
    DIFF_CONTAINER("containerdiff", false, true, false, "CamelDockerContainerId", String.class),
    INSPECT_CONTAINER("inspectcontainer", false, true, false, "CamelDockerContainerId", String.class),
    KILL_CONTAINER("containerkill", false, true, false, "CamelDockerContainerId", String.class, "CamelDockerSignal", String.class),
    LIST_CONTAINERS("containerlist", false, true, false, "CamelDockerBefore", String.class, "CamelDockerLimit", String.class, "CamelDockerShowAll", Boolean.class, "CamelDockerShowSize", Boolean.class, "CamelDockerSince", String.class),
    LOG_CONTAINER("containerlog", false, true, true, "CamelDockerContainerId", String.class, "CamelDockerFollowStream", Boolean.class, "CamelDockerStdErr", Boolean.class, "CamelDockerStdOut", Boolean.class, "CamelDockerTail", Integer.class, "CamelDockerTailAll", Boolean.class, "CamelDockerTimestamps", Boolean.class),
    PAUSE_CONTAINER("containerpause", false, true, false, "CamelDockerContainerId", String.class),
    RESTART_CONTAINER("containerrestart", false, true, false, "CamelDockerContainerId", String.class, "CamelDockerTimeout", Integer.class),
    REMOVE_CONTAINER("containerremove", false, true, false, "CamelDockerContainerId", String.class, "CamelDockerForce", Boolean.class, "CamelDockerRemoveVolumes", Boolean.class),
    START_CONTAINER("containerstart", false, true, false, "CamelDockerContainerId", String.class),
    STOP_CONTAINER("containerstop", false, true, false, "CamelDockerContainerId", String.class, "CamelDockerTimeout", Integer.class),
    TOP_CONTAINER("containertop", false, true, false, "CamelDockerContainerId", String.class, "CamelDockerPsArgs", String.class),
    UNPAUSE_CONTAINER("containerunpause", false, true, false, "CamelDockerContainerId", String.class),
    CREATE_NETWORK("networkcreate", false, true, false, "CamelDockerNetwork", String.class),
    REMOVE_NETWORK("networkremove", false, true, false, "CamelDockerNetwork", String.class),
    CONNECT_NETWORK("networkconnect", false, true, false, "CamelDockerNetwork", String.class, "CamelDockerContainerId", String.class),
    WAIT_CONTAINER("containerwait", false, true, true, "CamelDockerContainerId", String.class),
    EXEC_CREATE("execcreate", false, true, false, "CamelDockerAttachStdErr", Boolean.class, "CamelDockerAttachStdIn", Boolean.class, "CamelDockerAttachStdOut", Boolean.class, "CamelDockerTty", Boolean.class),
    EXEC_START("execstart", false, true, true, "CamelDockerDetach", Boolean.class, "CamelDockerExecId", String.class, "CamelDockerTty", Boolean.class);

    private String text;
    private boolean canConsume;
    private boolean canProduce;
    private boolean async;
    private Map<String, Class<?>> parameters;

    private DockerOperation(String text, boolean canConsume, boolean canProduce, boolean async, Object ... params) {
        this.text = text;
        this.canConsume = canConsume;
        this.canProduce = canProduce;
        this.async = async;
        this.parameters = new HashMap();
        if (params.length > 0) {
            if (params.length % 2 != 0) {
                throw new IllegalArgumentException("Invalid parameter list, must be of the form 'String name1, Class class1, String name2, Class class2...");
            }
            int nParameters = params.length / 2;
            for (int i = 0; i < nParameters; ++i) {
                this.parameters.put((String)params[i * 2], (Class)params[i * 2 + 1]);
            }
        }
    }

    public String toString() {
        return this.text;
    }

    public boolean canConsume() {
        return this.canConsume;
    }

    public boolean canProduce() {
        return this.canProduce;
    }

    public boolean isAsync() {
        return this.async;
    }

    public Map<String, Class<?>> getParameters() {
        return this.parameters;
    }

    public static DockerOperation getDockerOperation(String name) {
        for (DockerOperation dockerOperation : DockerOperation.values()) {
            if (!dockerOperation.toString().equals(name)) continue;
            return dockerOperation;
        }
        return null;
    }
}

