/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.consumer;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.EventsCmd;
import com.github.dockerjava.api.model.Event;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.docker.DockerClientFactory;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.DockerEndpoint;
import org.apache.camel.component.docker.DockerHelper;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerEventsConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(DockerEventsConsumer.class);
    private DockerEndpoint endpoint;
    private DockerComponent component;
    private EventsCmd eventsCmd;

    public DockerEventsConsumer(DockerEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.component = (DockerComponent)endpoint.getComponent();
    }

    public DockerEndpoint getEndpoint() {
        return (DockerEndpoint)super.getEndpoint();
    }

    private long processInitialEvent() {
        long currentTime = System.currentTimeMillis();
        Long initialRange = DockerHelper.getProperty("CamelDockerInitialRange", this.endpoint.getConfiguration(), null, Long.class);
        if (initialRange != null) {
            currentTime -= initialRange.longValue();
        }
        return currentTime;
    }

    protected void doStart() throws Exception {
        this.eventsCmd = DockerClientFactory.getDockerClient(this.component, this.endpoint.getConfiguration(), null).eventsCmd().withSince(String.valueOf(this.processInitialEvent()));
        this.eventsCmd.exec((ResultCallback)new EventsCallback());
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.eventsCmd.close();
        super.doStop();
    }

    protected class EventsCallback
    extends ResultCallback.Adapter<Event> {
        protected EventsCallback() {
        }

        public void onNext(Event event) {
            LOG.debug("Received Docker Event: {}", (Object)event);
            Exchange exchange = DockerEventsConsumer.this.createExchange(true);
            Message message = exchange.getIn();
            message.setBody((Object)event);
            AsyncCallback cb = DockerEventsConsumer.this.defaultConsumerCallback(exchange, true);
            DockerEventsConsumer.this.getAsyncProcessor().process(exchange, cb);
        }
    }
}

