/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.consumer;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DropboxScheduledPollConsumer
extends ScheduledPollConsumer {
    protected static final transient Logger LOG = LoggerFactory.getLogger(DropboxScheduledPollConsumer.class);
    protected final DropboxEndpoint endpoint;
    protected final DropboxConfiguration configuration;

    public DropboxScheduledPollConsumer(DropboxEndpoint endpoint, Processor processor, DropboxConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    protected abstract int poll() throws Exception;

    protected void doStart() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.createClient();
            LOG.debug("Consumer DropBox client created");
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.configuration.getClient() == null) {
            this.configuration.setClient(null);
            LOG.debug("Consumer DropBox client deleted");
        }
        super.doStop();
    }
}

