/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.util.Optional;
import java.util.UUID;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.component.dynamicrouter.DynamicRouterComponent;
import org.apache.camel.component.dynamicrouter.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.DynamicRouterControlMessage;
import org.apache.camel.component.dynamicrouter.DynamicRouterProcessor;
import org.apache.camel.spi.Language;
import org.apache.camel.support.AsyncProcessorSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRouterControlChannelProcessor
extends AsyncProcessorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterControlChannelProcessor.class);
    private DynamicRouterConfiguration configuration;
    private final DynamicRouterComponent component;

    public DynamicRouterControlChannelProcessor(DynamicRouterComponent component) {
        this.component = component;
    }

    Predicate obtainPredicate(Object body) {
        Predicate predicate;
        String exLang = this.configuration.getExpressionLanguage();
        String value = this.configuration.getPredicate();
        Predicate bean = this.configuration.getPredicateBean();
        if (bean != null) {
            predicate = bean;
        } else if (value != null && !value.isEmpty() && exLang != null && !exLang.isEmpty()) {
            try {
                Language language = this.component.getCamelContext().resolveLanguage(exLang);
                predicate = language.createPredicate(value);
            }
            catch (Exception e) {
                String message = String.format("Language '%s' and predicate expression '%s' could not create a valid predicate", exLang, value);
                throw new IllegalArgumentException(message, e);
            }
        } else if (Predicate.class.isAssignableFrom(body.getClass())) {
            predicate = (Predicate)body;
        } else {
            throw new IllegalArgumentException("Subscription predicate must be provided either by an expression inthe URI, as the message body, or as a property in a control channelmessage");
        }
        return predicate;
    }

    DynamicRouterControlMessage handleControlMessage(Exchange exchange) {
        DynamicRouterControlMessage controlMessage;
        String controlAction = this.configuration.getControlAction();
        Object body = exchange.getIn().getBody();
        if (controlAction != null && !controlAction.isEmpty()) {
            switch (controlAction) {
                case "unsubscribe": {
                    controlMessage = new DynamicRouterControlMessage.UnsubscribeMessageBuilder().channel(this.configuration.getSubscribeChannel()).id(this.configuration.getSubscriptionId()).build();
                    break;
                }
                case "subscribe": {
                    String subscriptionId = this.configuration.getSubscriptionId() == null ? UUID.randomUUID().toString() : this.configuration.getSubscriptionId();
                    controlMessage = new DynamicRouterControlMessage.SubscribeMessageBuilder().channel(this.configuration.getSubscribeChannel()).id(subscriptionId).endpointUri(this.configuration.getDestinationUri()).priority(this.configuration.getPriority()).predicate(this.obtainPredicate(body)).build();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal control channel action: " + controlAction);
                }
            }
        } else if (DynamicRouterControlMessage.class.isAssignableFrom(body.getClass())) {
            controlMessage = (DynamicRouterControlMessage)body;
        } else {
            throw new IllegalArgumentException("Could not create or find a control channel message");
        }
        return controlMessage;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        LOG.debug("Received control channel message");
        DynamicRouterControlMessage controlMessage = this.handleControlMessage(exchange);
        DynamicRouterProcessor processor = Optional.ofNullable(this.component.getRoutingProcessor(controlMessage.getChannel())).orElseThrow(() -> new IllegalArgumentException("Control channel message is invalid: wrong channel, or no processors present."));
        switch (controlMessage.getMessageType()) {
            case SUBSCRIBE: {
                processor.addFilter(controlMessage);
                exchange.getIn().setBody((Object)controlMessage.getId(), String.class);
                break;
            }
            case UNSUBSCRIBE: {
                processor.removeFilter(controlMessage.getId());
                break;
            }
        }
        callback.done(true);
        return true;
    }

    public void setConfiguration(DynamicRouterConfiguration configuration) {
        this.configuration = configuration;
    }

    public static class DynamicRouterControlChannelProcessorFactory {
        public DynamicRouterControlChannelProcessor getInstance(DynamicRouterComponent dynamicRouterComponent) {
            return new DynamicRouterControlChannelProcessor(dynamicRouterComponent);
        }
    }
}

