/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.dynamicrouter.DynamicRouterComponent;
import org.apache.camel.component.dynamicrouter.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.DynamicRouterEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRouterControlProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterControlProducer.class);
    private final DynamicRouterEndpoint endpoint;
    private final DynamicRouterConfiguration configuration;

    public DynamicRouterControlProducer(DynamicRouterEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        LOG.debug("Created producer for endpoint '{}', channel '{}'", (Object)endpoint.getEndpointUri(), (Object)this.configuration.getChannel());
    }

    private DynamicRouterComponent getComponent() {
        return this.endpoint.getDynamicRouterComponent();
    }

    public void process(Exchange exchange) throws Exception {
        this.getComponent().getControlChannelProcessor().process(exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        block6: {
            try {
                if (this.configuration.isSynchronous()) {
                    this.process(exchange);
                    break block6;
                }
                boolean bl = this.getComponent().getControlChannelProcessor().process(exchange, callback);
                return bl;
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            finally {
                callback.done(true);
            }
        }
        return true;
    }

    public static class DynamicRouterControlProducerFactory {
        public DynamicRouterControlProducer getInstance(DynamicRouterEndpoint endpoint) {
            return new DynamicRouterControlProducer(endpoint);
        }
    }
}

