/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.dynamicrouter.DynamicRouterControlMessage;
import org.apache.camel.component.dynamicrouter.PrioritizedFilterProcessor;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.builder.PredicateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed Dynamic Router Processor")
public class DynamicRouterProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterProcessor.class);
    private static final String LOG_ENDPOINT = "log:%s.%s?level=%s&showAll=true&multiline=true";
    private final TreeMap<String, PrioritizedFilterProcessor> filterMap;
    private final CamelContext camelContext;
    private final String recipientMode;
    private final ProducerTemplate producerTemplate;
    private PrioritizedFilterProcessor defaultProcessor;
    private ExecutorService executorService;
    private ReactiveExecutor reactiveExecutor;
    private final Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier;
    private final boolean warnDroppedMessage;
    private String id;

    public DynamicRouterProcessor(String id, CamelContext camelContext, String recipientMode, boolean warnDroppedMessage, Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier) {
        this.id = id;
        this.filterMap = new TreeMap();
        this.camelContext = camelContext;
        this.recipientMode = recipientMode;
        this.producerTemplate = camelContext.createProducerTemplate();
        this.filterProcessorFactorySupplier = filterProcessorFactorySupplier;
        this.warnDroppedMessage = warnDroppedMessage;
        LOG.debug("Created Dynamic Router Processor");
    }

    protected void doInit() throws Exception {
        super.doInit();
        ExtendedCamelContext extendedCamelContext = this.camelContext.getCamelContextExtension();
        this.reactiveExecutor = extendedCamelContext.getReactiveExecutor();
        this.executorService = this.camelContext.getExecutorServiceManager().newDefaultThreadPool((Object)this, "dynamicRouterMulticastPool");
        String message = String.format(LOG_ENDPOINT, ((Object)((Object)this)).getClass().getCanonicalName(), this.getId(), this.warnDroppedMessage ? "WARN" : "DEBUG");
        this.defaultProcessor = this.filterProcessorFactorySupplier.get().getInstance("defaultProcessor", Integer.MAX_VALUE, this.camelContext, PredicateBuilder.constant((boolean)true), exchange -> {
            String error = String.format("DynamicRouter '%s': no filters matched for an exchange with id: '%s', from route: '%s'", this.getId(), exchange.getExchangeId(), exchange.getFromEndpoint());
            if (this.warnDroppedMessage) {
                LOG.warn(error);
            } else {
                LOG.debug(error);
            }
            this.producerTemplate.send(message, exchange);
        });
    }

    PrioritizedFilterProcessor createFilter(DynamicRouterControlMessage controlMessage) {
        String id = controlMessage.getId();
        int priority = controlMessage.getPriority();
        String endpoint = controlMessage.getEndpoint();
        Predicate predicate = controlMessage.getPredicate();
        Processor processor = exchange -> this.producerTemplate.send(endpoint, exchange);
        return this.filterProcessorFactorySupplier.get().getInstance(id, priority, this.camelContext, predicate, processor);
    }

    public void addFilter(DynamicRouterControlMessage controlMessage) {
        this.addFilter(this.createFilter(controlMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(PrioritizedFilterProcessor filter) {
        TreeMap<String, PrioritizedFilterProcessor> treeMap = this.filterMap;
        synchronized (treeMap) {
            if (filter != null) {
                this.filterMap.put(filter.getId(), filter);
                LOG.debug("Added subscription: {}", (Object)filter);
            }
        }
    }

    public PrioritizedFilterProcessor getFilter(String filterId) {
        return this.filterMap.get(filterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilter(String filterId) {
        TreeMap<String, PrioritizedFilterProcessor> treeMap = this.filterMap;
        synchronized (treeMap) {
            Optional.ofNullable(this.filterMap.remove(filterId)).ifPresentOrElse(f -> LOG.debug("Removed subscription: {}", f), () -> LOG.debug("No subscription exists with ID: {}", (Object)filterId));
        }
    }

    List<PrioritizedFilterProcessor> matchFilters(Exchange exchange) {
        return Optional.of(this.filterMap.values().stream().sorted().filter(f -> f.matches(exchange)).limit("firstMatch".equals(this.recipientMode) ? 1L : Integer.MAX_VALUE).collect(Collectors.toList())).filter(list -> !list.isEmpty()).orElse(Collections.singletonList(this.defaultProcessor));
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        List<PrioritizedFilterProcessor> matchingFilters = this.matchFilters(exchange);
        try {
            if ("allMatch".equals(this.recipientMode)) {
                for (PrioritizedFilterProcessor processor : matchingFilters) {
                    Exchange copy = ExchangeHelper.createCopy((Exchange)exchange, (boolean)true);
                    this.executorService.submit(() -> this.reactiveExecutor.schedule(() -> processor.process(copy, callback)));
                }
            } else {
                matchingFilters.stream().findFirst().ifPresent(p -> p.process(exchange, callback));
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static class DynamicRouterProcessorFactory {
        public DynamicRouterProcessor getInstance(String id, CamelContext camelContext, String recipientMode, boolean warnDroppedMessage, Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier) {
            return new DynamicRouterProcessor(id, camelContext, recipientMode, warnDroppedMessage, filterProcessorFactorySupplier);
        }
    }
}

