/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.control;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.dynamicrouter.control.DynamicRouterControlConstants;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.spi.annotations.SendDynamic;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.URISupport;

@SendDynamic(value="dynamic-router-control")
public class DynamicRouterControlChannelSendDynamicAware
extends SendDynamicAwareSupport {
    static Function<SendDynamicAware.DynamicAwareEntry, Processor> queryParamsHeadersProcessor = entry -> ex -> {
        Map entryProperties = entry.getProperties();
        Message message = ex.getMessage();
        DynamicRouterControlConstants.URI_PARAMS_TO_HEADER_NAMES.forEach((paramName, headerName) -> {
            if (entryProperties.containsKey(paramName)) {
                message.setHeader(headerName, entryProperties.get(paramName));
            }
        });
    };

    public boolean isLenientProperties() {
        return false;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map properties = this.endpointProperties(exchange, uri);
        URI normalizedUri = URISupport.normalizeUriAsURI((String)uri);
        String controlAction = URISupport.extractRemainderPath((URI)normalizedUri, (boolean)false);
        properties.put("controlAction", controlAction);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, null);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) {
        String optimizedUri = null;
        String uri = entry.getUri();
        if (DynamicRouterControlConstants.SHOULD_OPTIMIZE.test(uri)) {
            optimizedUri = URISupport.stripQuery((String)uri);
        }
        return optimizedUri;
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) {
        Processor preProcessor = null;
        if (DynamicRouterControlConstants.SHOULD_OPTIMIZE.test(entry.getUri())) {
            preProcessor = queryParamsHeadersProcessor.apply(entry);
        }
        return preProcessor;
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) {
        Processor postProcessor = null;
        if (DynamicRouterControlConstants.SHOULD_OPTIMIZE.test(entry.getUri())) {
            postProcessor = ex -> {
                Message message = exchange.getMessage();
                DynamicRouterControlConstants.URI_PARAMS_TO_HEADER_NAMES.values().forEach(arg_0 -> ((Message)message).removeHeader(arg_0));
            };
        }
        return postProcessor;
    }
}

