/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.rest.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.elasticsearch.rest.client.ElasticsearchRestClientEndpoint;
import org.apache.camel.component.elasticsearch.rest.client.ElasticsearchRestClientOperation;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.Sniffer;

public class ElasticsearchRestClientProducer
extends DefaultAsyncProducer {
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final String POST = "POST";
    public static final String GET = "GET";
    private ElasticsearchRestClientEndpoint endpoint;
    private RestClient restClient;
    private boolean createdRestClient;

    public ElasticsearchRestClientProducer(ElasticsearchRestClientEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.doProcess(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(true);
            return true;
        }
        return false;
    }

    public void doProcess(Exchange exchange, AsyncCallback callback) throws Exception {
        String indexName = this.endpoint.getIndexName();
        if (ObjectHelper.isEmpty((String)indexName) && ObjectHelper.isEmpty((String)(indexName = (String)exchange.getMessage().getHeader("INDEX_NAME", String.class)))) {
            throw new IllegalArgumentException("Index Name is mandatory");
        }
        Request request = this.generateRequest(exchange, indexName);
        this.performRequest(exchange, callback, request);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.restClient = this.endpoint.getRestClient();
        if (this.restClient == null) {
            this.restClient = this.createClient();
            this.createdRestClient = true;
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.createdRestClient && this.restClient != null) {
            IOHelper.close((Closeable)this.restClient);
            this.restClient = null;
        }
    }

    private Request generateRequest(Exchange exchange, String indexName) throws Exception {
        return switch (this.endpoint.getOperation()) {
            default -> throw new IncompatibleClassChangeError();
            case ElasticsearchRestClientOperation.CREATE_INDEX -> this.createIndexRequest(indexName, exchange);
            case ElasticsearchRestClientOperation.DELETE_INDEX -> this.deleteIndexRequest(indexName);
            case ElasticsearchRestClientOperation.INDEX_OR_UPDATE -> this.indexRequest(indexName, exchange);
            case ElasticsearchRestClientOperation.GET_BY_ID -> this.getById(indexName, exchange);
            case ElasticsearchRestClientOperation.SEARCH -> this.search(indexName, exchange);
            case ElasticsearchRestClientOperation.DELETE -> this.delete(indexName, exchange);
        };
    }

    private void performRequest(final Exchange exchange, final AsyncCallback callback, Request request) {
        this.restClient.performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                try {
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JsonObject jsonObject = this.convertHttpEntityToJsonObject(responseBody);
                    this.populateExchange(jsonObject);
                }
                catch (Exception e) {
                    exchange.setException((Throwable)e);
                }
                callback.done(false);
            }

            private JsonObject convertHttpEntityToJsonObject(String httpResponse) throws IOException {
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(httpResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
                return new JsonObject(map);
            }

            private void populateExchange(JsonObject doc) {
                switch (ElasticsearchRestClientProducer.this.endpoint.getOperation()) {
                    case INDEX_OR_UPDATE: {
                        exchange.getMessage().setBody((Object)ElasticsearchRestClientProducer.this.extractID(doc));
                        break;
                    }
                    case CREATE_INDEX: 
                    case DELETE_INDEX: {
                        exchange.getMessage().setBody((Object)ElasticsearchRestClientProducer.this.extractAck(doc));
                        break;
                    }
                    case DELETE: {
                        exchange.getMessage().setBody((Object)ElasticsearchRestClientProducer.this.extractDeleted(doc));
                        break;
                    }
                    case GET_BY_ID: {
                        exchange.getMessage().setBody((Object)ElasticsearchRestClientProducer.this.extractDocument(doc));
                        break;
                    }
                    case SEARCH: {
                        exchange.getMessage().setBody((Object)ElasticsearchRestClientProducer.this.extractSearch(doc));
                    }
                }
            }

            public void onFailure(Exception e) {
                exchange.setException((Throwable)e);
                callback.done(false);
            }
        });
    }

    private Request createIndexRequest(String indexName, Exchange exchange) {
        String endpoint = String.format("/%s", indexName);
        Request request = new Request(PUT, endpoint);
        String additionalParameters = (String)exchange.getMessage().getHeader("INDEX_SETTINGS", String.class);
        if (ObjectHelper.isNotEmpty((String)additionalParameters)) {
            request.setEntity((HttpEntity)new NStringEntity(additionalParameters, ContentType.APPLICATION_JSON));
        }
        return request;
    }

    private Request deleteIndexRequest(String indexName) {
        String endpoint = String.format("/%s", indexName);
        return new Request(DELETE, endpoint);
    }

    private Request indexRequest(String indexName, Exchange exchange) throws InvalidPayloadException {
        String jsonBody = (String)exchange.getMessage().getMandatoryBody(String.class);
        String endpoint = String.format("/%s/_doc", indexName);
        Object id = exchange.getMessage().getHeader("ID");
        if (ObjectHelper.isNotEmpty((Object)id)) {
            endpoint = String.format("%s/%s", endpoint, id);
        }
        Request request = new Request(POST, endpoint);
        request.setEntity((HttpEntity)new NStringEntity(jsonBody, ContentType.APPLICATION_JSON));
        return request;
    }

    private Request getById(String indexName, Exchange exchange) {
        String id = (String)exchange.getMessage().getBody(String.class);
        if (ObjectHelper.isEmpty((String)id) && ObjectHelper.isEmpty((String)(id = (String)exchange.getMessage().getHeader("ID", String.class)))) {
            throw new IllegalArgumentException("id value is mandatory when performing GET_BY_ID operation");
        }
        String endpoint = String.format("/%s/_doc/%s", indexName, id);
        return new Request(GET, endpoint);
    }

    private Request delete(String indexName, Exchange exchange) {
        String id = (String)exchange.getMessage().getBody(String.class);
        if (ObjectHelper.isEmpty((String)id) && ObjectHelper.isEmpty((String)(id = (String)exchange.getMessage().getHeader("ID", String.class)))) {
            throw new IllegalArgumentException("id value is mandatory when performing DELETE operation");
        }
        String endpoint = String.format("/%s/_doc/%s", indexName, id);
        return new Request(DELETE, endpoint);
    }

    private Request search(String indexName, Exchange exchange) {
        String endpoint = String.format("/%s/_search", indexName);
        Request request = new Request(GET, endpoint);
        String advancedQuery = (String)exchange.getMessage().getHeader("SEARCH_QUERY", String.class);
        if (ObjectHelper.isNotEmpty((String)advancedQuery)) {
            request.setJsonEntity(advancedQuery);
        } else {
            Map queryParameters = (Map)exchange.getMessage().getBody(Map.class);
            if (ObjectHelper.isNotEmpty((Map)queryParameters)) {
                String jsonRequest = this.createQueryFromMap(queryParameters);
                request.setJsonEntity(jsonRequest);
            }
        }
        return request;
    }

    private String createQueryFromMap(Map<String, String> queryParameters) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode matchObject = objectMapper.createObjectNode();
        ArrayNode mustArray = objectMapper.createArrayNode();
        for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
            ObjectNode fieldObject = objectMapper.createObjectNode();
            fieldObject.set("match", (JsonNode)objectMapper.createObjectNode().put(entry.getKey(), entry.getValue()));
            mustArray.add((JsonNode)fieldObject);
        }
        matchObject.set("must", (JsonNode)mustArray);
        ObjectNode boolObject = (ObjectNode)objectMapper.createObjectNode().set("bool", (JsonNode)matchObject);
        ObjectNode queryObject = (ObjectNode)objectMapper.createObjectNode().set("query", (JsonNode)boolObject);
        return queryObject.toPrettyString();
    }

    boolean extractAck(JsonObject doc) {
        return doc.getBoolean("acknowledged");
    }

    boolean extractDeleted(JsonObject doc) {
        return "deleted".equals(doc.getString("result"));
    }

    String extractID(JsonObject doc) {
        return doc.getString("_id");
    }

    String extractDocument(JsonObject doc) {
        Boolean found = doc.getBoolean("found");
        if (!found.booleanValue()) {
            return null;
        }
        Map map = doc.getMap("_source");
        JsonObject jsonObject = new JsonObject(map);
        return jsonObject.toJson();
    }

    String extractSearch(JsonObject doc) {
        Map hitsLevel1 = doc.getMap("hits");
        List hitsLevel2 = (List)hitsLevel1.get("hits");
        List extractedValues = hitsLevel2.stream().map(map -> map.get("_source")).collect(Collectors.toList());
        JsonArray response = new JsonArray(extractedValues);
        return response.toJson();
    }

    private RestClient createClient() throws Exception {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.getHttpHosts());
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.endpoint.getConnectionTimeout()).setSocketTimeout(this.endpoint.getSocketTimeout()));
        if (this.endpoint.getUser() != null && this.endpoint.getPassword() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.endpoint.getUser(), this.endpoint.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> this.lambda$createClient$2((CredentialsProvider)credentialsProvider, arg_0));
        }
        RestClient restClient = builder.build();
        if (this.endpoint.isEnableSniffer()) {
            Sniffer.builder((RestClient)restClient).setSniffIntervalMillis(this.endpoint.getSnifferInterval()).setSniffAfterFailureDelayMillis(this.endpoint.getSniffAfterFailureDelay()).build();
        }
        return restClient;
    }

    private HttpHost[] getHttpHosts() {
        if (ObjectHelper.isEmpty((String)this.endpoint.getHostAddressesList())) {
            throw new IllegalArgumentException("RestClient or HostAddressesList is mandatory");
        }
        String[] hostAdresses = this.endpoint.getHostAddressesList().split(",");
        HttpHost[] httpHostArray = (HttpHost[])Arrays.stream(hostAdresses).map(address -> HttpHost.create((String)address.trim())).toArray(HttpHost[]::new);
        return httpHostArray;
    }

    private SSLContext createSslContextFromCa() {
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            InputStream resolveMandatoryResourceAsInputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getEndpoint().getCamelContext(), (String)this.endpoint.getCertificatePath());
            Certificate trustedCa = factory.generateCertificate(resolveMandatoryResourceAsInputStream);
            KeyStore trustStore = KeyStore.getInstance("pkcs12");
            trustStore.load(null, null);
            trustStore.setCertificateEntry("ca", trustedCa);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.3");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$createClient$2(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        if (this.endpoint.getCertificatePath() != null) {
            httpClientBuilder.setSSLContext(this.createSslContextFromCa());
        }
        return httpClientBuilder;
    }
}

