/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchEndpoint;
import org.apache.camel.component.elasticsearch.ElasticsearchRestComponentVerifierExtension;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;

@Component(value="elasticsearch-rest")
public class ElasticsearchComponent
extends DefaultComponent {
    @Metadata(label="advanced", autowired=true)
    private RestClient client;
    @Metadata(label="advanced")
    private String hostAddresses;
    @Metadata(label="advanced", defaultValue="30000")
    private int socketTimeout = 30000;
    @Metadata(label="advanced", defaultValue="30000")
    private int maxRetryTimeout = 30000;
    @Metadata(label="advanced", defaultValue="30000")
    private int connectionTimeout = 30000;
    @Metadata(label="security")
    private String user;
    @Metadata(label="security", secret=true)
    private String password;
    @Metadata(label="security", defaultValue="false")
    private boolean enableSSL;
    @Metadata(label="advanced", defaultValue="false")
    private boolean enableSniffer;
    @Metadata(label="advanced", defaultValue="300000")
    private int snifferInterval = 300000;
    @Metadata(label="advanced", defaultValue="60000")
    private int sniffAfterFailureDelay = 60000;

    public ElasticsearchComponent() {
        this(null);
    }

    public ElasticsearchComponent(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new ElasticsearchRestComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ElasticsearchConfiguration config = new ElasticsearchConfiguration();
        config.setHostAddresses(this.getHostAddresses());
        config.setSocketTimeout(this.getSocketTimeout());
        config.setMaxRetryTimeout(this.getMaxRetryTimeout());
        config.setConnectionTimeout(this.getConnectionTimeout());
        config.setUser(this.getUser());
        config.setEnableSSL(this.getEnableSSL());
        config.setPassword(this.getPassword());
        config.setEnableSniffer(this.getEnableSniffer());
        config.setSnifferInterval(this.getSnifferInterval());
        config.setSniffAfterFailureDelay(this.getSniffAfterFailureDelay());
        config.setClusterName(remaining);
        ElasticsearchEndpoint endpoint = new ElasticsearchEndpoint(uri, this, config, this.client);
        this.setProperties((Endpoint)endpoint, parameters);
        config.setHostAddressesList(this.parseHostAddresses(config.getHostAddresses(), config));
        return endpoint;
    }

    private List<HttpHost> parseHostAddresses(String ipsString, ElasticsearchConfiguration config) {
        if (ipsString == null || ipsString.isEmpty()) {
            return null;
        }
        List<String> addressesStr = Arrays.asList(ipsString.split(","));
        ArrayList<HttpHost> addressesTrAd = new ArrayList<HttpHost>(addressesStr.size());
        for (String address : addressesStr) {
            String[] split = address.split(":");
            if (split.length <= 0) {
                throw new IllegalArgumentException();
            }
            String hostname = split[0];
            int port = split.length > 1 ? Integer.parseInt(split[1]) : 9200;
            addressesTrAd.add(new HttpHost(hostname, port, config.isEnableSSL() ? "HTTPS" : "HTTP"));
        }
        return addressesTrAd;
    }

    public RestClient getClient() {
        return this.client;
    }

    public void setClient(RestClient client) {
        this.client = client;
    }

    public String getHostAddresses() {
        return this.hostAddresses;
    }

    public void setHostAddresses(String hostAddresses) {
        this.hostAddresses = hostAddresses;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getEnableSSL() {
        return this.enableSSL;
    }

    public void setEnableSSL(Boolean enableSSL) {
        this.enableSSL = enableSSL;
    }

    public int getMaxRetryTimeout() {
        return this.maxRetryTimeout;
    }

    public void setMaxRetryTimeout(int maxRetryTimeout) {
        this.maxRetryTimeout = maxRetryTimeout;
    }

    public Boolean getEnableSniffer() {
        return this.enableSniffer;
    }

    public void setEnableSniffer(Boolean enableSniffer) {
        this.enableSniffer = enableSniffer;
    }

    public int getSnifferInterval() {
        return this.snifferInterval;
    }

    public void setSnifferInterval(int snifferInterval) {
        this.snifferInterval = snifferInterval;
    }

    public int getSniffAfterFailureDelay() {
        return this.sniffAfterFailureDelay;
    }

    public void setSniffAfterFailureDelay(int sniffAfterFailureDelay) {
        this.sniffAfterFailureDelay = sniffAfterFailureDelay;
    }
}

