/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.io.Closeable;
import java.util.Collections;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchEndpoint;
import org.apache.camel.component.elasticsearch.ElasticsearchOperation;
import org.apache.camel.component.elasticsearch.ElasticsearchScrollRequestIterator;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchProducer.class);
    protected final ElasticsearchConfiguration configuration;
    private RestClient client;
    private Sniffer sniffer;

    public ElasticsearchProducer(ElasticsearchEndpoint endpoint, ElasticsearchConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.client = endpoint.getClient();
    }

    private ElasticsearchOperation resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request instanceof IndexRequest) {
            return ElasticsearchOperation.Index;
        }
        if (request instanceof GetRequest) {
            return ElasticsearchOperation.GetById;
        }
        if (request instanceof MultiGetRequest) {
            return ElasticsearchOperation.MultiGet;
        }
        if (request instanceof UpdateRequest) {
            return ElasticsearchOperation.Update;
        }
        if (request instanceof BulkRequest) {
            if (this.configuration.getOperation() == ElasticsearchOperation.BulkIndex) {
                return ElasticsearchOperation.BulkIndex;
            }
            return ElasticsearchOperation.Bulk;
        }
        if (request instanceof DeleteRequest) {
            return ElasticsearchOperation.Delete;
        }
        if (request instanceof SearchRequest) {
            return ElasticsearchOperation.Search;
        }
        if (request instanceof MultiSearchRequest) {
            return ElasticsearchOperation.MultiSearch;
        }
        if (request instanceof DeleteIndexRequest) {
            return ElasticsearchOperation.DeleteIndex;
        }
        ElasticsearchOperation operationConfig = (ElasticsearchOperation)((Object)exchange.getIn().getHeader("operation", ElasticsearchOperation.class));
        if (operationConfig == null) {
            operationConfig = this.configuration.getOperation();
        }
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operationConfig) + "' is not supported");
        }
        return operationConfig;
    }

    public void process(Exchange exchange) throws Exception {
        Integer from;
        Integer size;
        if (this.configuration.isDisconnect() && this.client == null) {
            this.startClient();
        }
        HighLevelClient restHighLevelClient = new HighLevelClient(this.client);
        Message message = exchange.getIn();
        ElasticsearchOperation operation = this.resolveOperation(exchange);
        boolean configIndexName = false;
        String indexName = (String)message.getHeader("indexName", String.class);
        if (indexName == null) {
            message.setHeader("indexName", (Object)this.configuration.getIndexName());
            configIndexName = true;
        }
        if ((size = (Integer)message.getHeader("size", Integer.class)) == null) {
            message.setHeader("size", (Object)this.configuration.getSize());
        }
        if ((from = (Integer)message.getHeader("from", Integer.class)) == null) {
            message.setHeader("from", (Object)this.configuration.getFrom());
        }
        boolean configWaitForActiveShards = false;
        Integer waitForActiveShards = (Integer)message.getHeader("waitForActiveShards", Integer.class);
        if (waitForActiveShards == null) {
            message.setHeader("waitForActiveShards", (Object)this.configuration.getWaitForActiveShards());
            configWaitForActiveShards = true;
        }
        if (operation == ElasticsearchOperation.Index) {
            IndexRequest indexRequest = (IndexRequest)message.getBody(IndexRequest.class);
            if (indexRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only Map, String, byte[], XContentBuilder or IndexRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT).getId());
        } else if (operation == ElasticsearchOperation.Update) {
            UpdateRequest updateRequest = (UpdateRequest)message.getBody(UpdateRequest.class);
            if (updateRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only Map, String, byte[], XContentBuilder or UpdateRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT).getId());
        } else if (operation == ElasticsearchOperation.GetById) {
            GetRequest getRequest = (GetRequest)message.getBody(GetRequest.class);
            if (getRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only String or GetRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.get(getRequest, RequestOptions.DEFAULT));
        } else if (operation == ElasticsearchOperation.Bulk) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            if (bulkRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only List, Collection or BulkRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT).getItems());
        } else if (operation == ElasticsearchOperation.BulkIndex) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            if (bulkRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only List, Collection or BulkRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT).getItems());
        } else if (operation == ElasticsearchOperation.Delete) {
            DeleteRequest deleteRequest = (DeleteRequest)message.getBody(DeleteRequest.class);
            if (deleteRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only String or DeleteRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.delete(deleteRequest, RequestOptions.DEFAULT).getResult());
        } else if (operation == ElasticsearchOperation.DeleteIndex) {
            DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)message.getBody(DeleteIndexRequest.class);
            if (deleteIndexRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only String or DeleteIndexRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.indices().delete(deleteIndexRequest, RequestOptions.DEFAULT).isAcknowledged());
        } else if (operation == ElasticsearchOperation.Exists) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.size(0);
            sourceBuilder.terminateAfter(1);
            SearchRequest searchRequest = new SearchRequest(new String[]{(String)exchange.getIn().getHeader("indexName", String.class)});
            searchRequest.source(sourceBuilder);
            try {
                restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
                message.setBody((Object)true);
            }
            catch (ElasticsearchStatusException e) {
                if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                    message.setBody((Object)false);
                }
                throw new IllegalStateException(e);
            }
        } else if (operation == ElasticsearchOperation.Search) {
            SearchRequest searchRequest = (SearchRequest)message.getBody(SearchRequest.class);
            if (searchRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only Map, String or SearchRequest is allowed as a type");
            }
            boolean useScroll = (Boolean)message.getHeader("useScroll", (Object)this.configuration.isUseScroll(), Boolean.class);
            if (useScroll) {
                int scrollKeepAliveMs = (Integer)message.getHeader("scrollKeepAliveMs", (Object)this.configuration.getScrollKeepAliveMs(), Integer.class);
                ElasticsearchScrollRequestIterator scrollRequestIterator = new ElasticsearchScrollRequestIterator(searchRequest, restHighLevelClient, scrollKeepAliveMs, exchange);
                exchange.getIn().setBody((Object)scrollRequestIterator);
            } else {
                message.setBody((Object)restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT).getHits());
            }
        } else if (operation == ElasticsearchOperation.MultiSearch) {
            MultiSearchRequest searchRequest = (MultiSearchRequest)message.getBody(MultiSearchRequest.class);
            if (searchRequest == null) {
                throw new IllegalArgumentException("Wrong body type. Only MultiSearchRequest is allowed as a type");
            }
            message.setBody((Object)restHighLevelClient.msearch(searchRequest, RequestOptions.DEFAULT).getResponses());
        } else if (operation == ElasticsearchOperation.Ping) {
            message.setBody((Object)restHighLevelClient.ping(RequestOptions.DEFAULT));
        } else {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operation) + "' is not supported");
        }
        if (configIndexName) {
            message.removeHeader("indexName");
        }
        if (configWaitForActiveShards) {
            message.removeHeader("waitForActiveShards");
        }
        if (this.configuration.isDisconnect()) {
            IOHelper.close((Closeable)this.client);
            IOHelper.close((Closeable)((Object)restHighLevelClient));
            this.client = null;
            if (this.configuration.isEnableSniffer()) {
                IOHelper.close((Closeable)this.sniffer);
                this.sniffer = null;
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.configuration.isDisconnect()) {
            this.startClient();
        }
    }

    private void startClient() {
        if (this.client == null) {
            LOG.info("Connecting to the ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            if (this.configuration.getHostAddressesList() != null && !this.configuration.getHostAddressesList().isEmpty()) {
                this.client = this.createClient();
            } else {
                LOG.warn("Incorrect ip address and port parameters settings for ElasticSearch cluster");
            }
        }
    }

    private RestClient createClient() {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.configuration.getHostAddressesList().toArray(new HttpHost[0]));
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.configuration.getConnectionTimeout()).setSocketTimeout(this.configuration.getSocketTimeout()));
        if (this.configuration.getUser() != null && this.configuration.getPassword() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.getUser(), this.configuration.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchProducer.lambda$createClient$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        RestClient restClient = builder.build();
        if (this.configuration.isEnableSniffer()) {
            SnifferBuilder snifferBuilder = Sniffer.builder((RestClient)restClient);
            snifferBuilder.setSniffIntervalMillis(this.configuration.getSnifferInterval());
            snifferBuilder.setSniffAfterFailureDelayMillis(this.configuration.getSniffAfterFailureDelay());
            this.sniffer = snifferBuilder.build();
        }
        return restClient;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            LOG.info("Disconnecting from ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            this.client.close();
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        super.doStop();
    }

    public RestClient getClient() {
        return this.client;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return httpClientBuilder;
    }

    private final class HighLevelClient
    extends RestHighLevelClient {
        private HighLevelClient(RestClient restClient) {
            super(restClient, client -> {}, Collections.emptyList());
        }
    }
}

