/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elsql;

import com.opengamma.elsql.ElSql;
import com.opengamma.elsql.ElSqlConfig;
import com.opengamma.elsql.SpringSqlParams;
import com.opengamma.elsql.SqlParams;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.elsql.ElSqlDatabaseVendor;
import org.apache.camel.component.elsql.ElsqlConsumer;
import org.apache.camel.component.elsql.ElsqlProducer;
import org.apache.camel.component.elsql.ElsqlSqlMapSource;
import org.apache.camel.component.elsql.ElsqlSqlPrepareStatementStrategy;
import org.apache.camel.component.elsql.ElsqlSqlProcessingStrategy;
import org.apache.camel.component.sql.DefaultSqlEndpoint;
import org.apache.camel.component.sql.DefaultSqlPrepareStatementStrategy;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.component.sql.SqlProcessingStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

@UriEndpoint(firstVersion="2.16.0", scheme="elsql", title="ElSQL", syntax="elsql:elsqlName:resourceUri", category={Category.DATABASE, Category.SQL})
public class ElsqlEndpoint
extends DefaultSqlEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(ElsqlEndpoint.class);
    private ElSql elSql;
    private NamedParameterJdbcTemplate namedJdbcTemplate;
    @UriPath
    @Metadata(required=true)
    private String elsqlName;
    @UriPath
    private String resourceUri;
    @UriParam
    private ElSqlDatabaseVendor databaseVendor;
    @UriParam(label="advanced")
    private ElSqlConfig elSqlConfig;

    public ElsqlEndpoint(String endpointUri, Component component, String elsqlName, String resourceUri) {
        super(endpointUri, component);
        this.elsqlName = elsqlName;
        this.resourceUri = resourceUri;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ElsqlSqlProcessingStrategy proStrategy = new ElsqlSqlProcessingStrategy(this.elSql);
        ElsqlSqlPrepareStatementStrategy preStategy = new ElsqlSqlPrepareStatementStrategy();
        Exchange dummy = this.createExchange();
        ElsqlSqlMapSource param = new ElsqlSqlMapSource(dummy, null);
        String sql = this.elSql.getSql(this.elsqlName, (SqlParams)new SpringSqlParams((SqlParameterSource)param));
        LOG.debug("ElsqlConsumer @{} using sql: {}", (Object)this.elsqlName, (Object)sql);
        ElsqlConsumer consumer = new ElsqlConsumer(this, processor, this.namedJdbcTemplate, sql, (SqlParameterSource)param, preStategy, (SqlProcessingStrategy)proStrategy);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setOnConsume(this.getOnConsume());
        consumer.setOnConsumeFailed(this.getOnConsumeFailed());
        consumer.setOnConsumeBatchComplete(this.getOnConsumeBatchComplete());
        consumer.setBreakBatchOnConsumeFail(this.isBreakBatchOnConsumeFail());
        consumer.setExpectedUpdateCount(this.getExpectedUpdateCount());
        consumer.setUseIterator(this.isUseIterator());
        consumer.setRouteEmptyResultSet(this.isRouteEmptyResultSet());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        SqlPrepareStatementStrategy prepareStrategy = this.getPrepareStatementStrategy() != null ? this.getPrepareStatementStrategy() : new DefaultSqlPrepareStatementStrategy(this.getSeparator());
        ElsqlProducer result = new ElsqlProducer(this, this.elSql, this.elsqlName, this.namedJdbcTemplate, this.getDataSource(), prepareStrategy, this.isBatch());
        return result;
    }

    protected void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull((Object)this.resourceUri, (String)"resourceUri", (Object)((Object)this));
        if (this.elSqlConfig == null && this.databaseVendor != null) {
            this.elSqlConfig = this.databaseVendor.asElSqlConfig();
        } else if (this.elSqlConfig == null) {
            this.elSqlConfig = ElSqlDatabaseVendor.Default.asElSqlConfig();
        }
        this.parseResources(this.resourceUri, uri -> ResourceHelper.isClasspathUri((String)uri));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.parseResources(this.resourceUri, uri -> !ResourceHelper.isClasspathUri((String)uri));
    }

    private void parseResources(String resourceUri, Predicate<String> predicate) throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        Iterable it = org.apache.camel.support.ObjectHelper.createIterable((String)resourceUri);
        for (String path : it) {
            if (!predicate.test(path)) continue;
            URL url = ResourceHelper.resolveMandatoryResourceAsUrl((CamelContext)this.getCamelContext(), (String)path);
            list.add(url);
        }
        if (!list.isEmpty()) {
            URL[] urls = list.toArray(new URL[list.size()]);
            this.elSql = ElSql.parse((ElSqlConfig)this.elSqlConfig, (URL[])urls);
        }
    }

    public NamedParameterJdbcTemplate getNamedJdbcTemplate() {
        return this.namedJdbcTemplate;
    }

    public void setNamedJdbcTemplate(NamedParameterJdbcTemplate namedJdbcTemplate) {
        this.namedJdbcTemplate = namedJdbcTemplate;
    }

    public String getElsqlName() {
        return this.elsqlName;
    }

    public void setElsqlName(String elsqlName) {
        this.elsqlName = elsqlName;
    }

    public ElSqlDatabaseVendor getDatabaseVendor() {
        return this.databaseVendor;
    }

    public void setDatabaseVendor(ElSqlDatabaseVendor databaseVendor) {
        this.databaseVendor = databaseVendor;
    }

    public ElSqlConfig getElSqlConfig() {
        return this.elSqlConfig;
    }

    public void setElSqlConfig(ElSqlConfig elSqlConfig) {
        this.elSqlConfig = elSqlConfig;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

