/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elsql;

import com.opengamma.elsql.ElSqlConfig;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.elsql.ElSqlDatabaseVendor;
import org.apache.camel.component.elsql.ElsqlEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

@org.apache.camel.spi.annotations.Component(value="elsql")
public class ElsqlComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(ElsqlComponent.class);
    @Metadata(autowired=true)
    private DataSource dataSource;
    @Metadata
    private ElSqlDatabaseVendor databaseVendor;
    @Metadata(label="advanced")
    private ElSqlConfig elSqlConfig;
    @Metadata
    private String resourceUri;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String onConsumeBatchComplete;
        String onConsumeFailed;
        String elsqlName = remaining;
        String resUri = this.resourceUri;
        String[] part = remaining.split(":");
        if (part.length == 2) {
            elsqlName = part[0];
            resUri = part[1];
        } else if (part.length > 2) {
            throw new IllegalArgumentException("Invalid uri. Must by elsql:elsqlName:resourceUri, was: " + uri);
        }
        String onConsume = (String)this.getAndRemoveParameter(parameters, "consumer.onConsume", String.class);
        if (onConsume == null) {
            onConsume = (String)this.getAndRemoveParameter(parameters, "onConsume", String.class);
        }
        if ((onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeFailed", String.class)) == null) {
            onConsumeFailed = (String)this.getAndRemoveParameter(parameters, "onConsumeFailed", String.class);
        }
        if ((onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "consumer.onConsumeBatchComplete", String.class)) == null) {
            onConsumeBatchComplete = (String)this.getAndRemoveParameter(parameters, "onConsumeBatchComplete", String.class);
        }
        ElsqlEndpoint endpoint = new ElsqlEndpoint(uri, (Component)this, elsqlName, resUri);
        endpoint.setElSqlConfig(this.elSqlConfig);
        endpoint.setDatabaseVendor(this.databaseVendor);
        endpoint.setOnConsume(onConsume);
        endpoint.setOnConsumeFailed(onConsumeFailed);
        endpoint.setOnConsumeBatchComplete(onConsumeBatchComplete);
        DataSource ds = this.dataSource;
        if (endpoint.getDataSource() != null) {
            ds = endpoint.getDataSource();
        }
        if (ds == null) {
            throw new IllegalArgumentException("DataSource must be configured");
        }
        NamedParameterJdbcTemplate jdbcTemplate = new NamedParameterJdbcTemplate(ds);
        Map templateOptions = PropertiesHelper.extractProperties(parameters, (String)"template.");
        PropertyBindingSupport.bindProperties((CamelContext)this.getCamelContext(), (Object)jdbcTemplate, (Map)templateOptions);
        endpoint.setNamedJdbcTemplate(jdbcTemplate);
        endpoint.setDataSource(ds);
        endpoint.setTemplateOptions(templateOptions);
        return endpoint;
    }

    public ElSqlDatabaseVendor getDatabaseVendor() {
        return this.databaseVendor;
    }

    public void setDatabaseVendor(ElSqlDatabaseVendor databaseVendor) {
        this.databaseVendor = databaseVendor;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ElSqlConfig getElSqlConfig() {
        return this.elSqlConfig;
    }

    public void setElSqlConfig(ElSqlConfig elSqlConfig) {
        this.elSqlConfig = elSqlConfig;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

