/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Manage financial transactions using IOTA distributed ledger.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface IOTAEndpointBuilderFactory {


    /**
     * Builder for endpoint for the IOTA component.
     */
    public interface IOTAEndpointBuilder extends EndpointProducerBuilder {
        default AdvancedIOTAEndpointBuilder advanced() {
            return (AdvancedIOTAEndpointBuilder) this;
        }
        /**
         * The depth determines how deep the tangle is analysed for getting
         * Tips.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 9
         * Group: producer
         * 
         * @param depth the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder depth(Integer depth) {
            doSetProperty("depth", depth);
            return this;
        }
        /**
         * The depth determines how deep the tangle is analysed for getting
         * Tips.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 9
         * Group: producer
         * 
         * @param depth the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder depth(String depth) {
            doSetProperty("depth", depth);
            return this;
        }
        /**
         * The minWeightMagnitude is the minimum number of zeroes that a
         * proof-of-work output/transaction hash must end with to be considered
         * valid by full nodes.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 14
         * Group: producer
         * 
         * @param minWeightMagnitude the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder minWeightMagnitude(
                Integer minWeightMagnitude) {
            doSetProperty("minWeightMagnitude", minWeightMagnitude);
            return this;
        }
        /**
         * The minWeightMagnitude is the minimum number of zeroes that a
         * proof-of-work output/transaction hash must end with to be considered
         * valid by full nodes.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 14
         * Group: producer
         * 
         * @param minWeightMagnitude the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder minWeightMagnitude(String minWeightMagnitude) {
            doSetProperty("minWeightMagnitude", minWeightMagnitude);
            return this;
        }
        /**
         * Which operation to perform, one of: sendTransfer, getNewAddress,
         * getTransfers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * TAG.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param tag the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder tag(String tag) {
            doSetProperty("tag", tag);
            return this;
        }
        /**
         * Node url.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Required: true
         * Group: producer
         * 
         * @param url the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder url(String url) {
            doSetProperty("url", url);
            return this;
        }
        /**
         * Security level to be used for the private key / address. Can be 1, 2
         * or 3.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder securityLevel(Integer securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
        /**
         * Security level to be used for the private key / address. Can be 1, 2
         * or 3.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: security
         * 
         * @param securityLevel the value to set
         * @return the dsl builder
         */
        default IOTAEndpointBuilder securityLevel(String securityLevel) {
            doSetProperty("securityLevel", securityLevel);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IOTA component.
     */
    public interface AdvancedIOTAEndpointBuilder
            extends
                EndpointProducerBuilder {
        default IOTAEndpointBuilder basic() {
            return (IOTAEndpointBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIOTAEndpointBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedIOTAEndpointBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface IOTABuilders {
        /**
         * IOTA (camel-iota)
         * Manage financial transactions using IOTA distributed ledger.
         * 
         * Category: ledger,api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-iota
         * 
         * @return the dsl builder for the headers' name.
         */
        default IOTAHeaderNameBuilder iota() {
            return IOTAHeaderNameBuilder.INSTANCE;
        }
        /**
         * IOTA (camel-iota)
         * Manage financial transactions using IOTA distributed ledger.
         * 
         * Category: ledger,api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-iota
         * 
         * Syntax: <code>iota:name</code>
         * 
         * Path parameter: name (required)
         * Component name
         * 
         * @param path name
         * @return the dsl builder
         */
        default IOTAEndpointBuilder iota(String path) {
            return IOTAEndpointBuilderFactory.endpointBuilder("iota", path);
        }
        /**
         * IOTA (camel-iota)
         * Manage financial transactions using IOTA distributed ledger.
         * 
         * Category: ledger,api
         * Since: 2.23
         * Maven coordinates: org.apache.camel:camel-iota
         * 
         * Syntax: <code>iota:name</code>
         * 
         * Path parameter: name (required)
         * Component name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path name
         * @return the dsl builder
         */
        default IOTAEndpointBuilder iota(String componentName, String path) {
            return IOTAEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the IOTA component.
     */
    public static class IOTAHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final IOTAHeaderNameBuilder INSTANCE = new IOTAHeaderNameBuilder();

        /**
         * The tryte-encoded seed.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IOTASeed}.
         */
        public String iOTASeed() {
            return "IOTASeed";
        }

        /**
         * The value to transfer.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IOTAValue}.
         */
        public String iOTAValue() {
            return "IOTAValue";
        }

        /**
         * The address of the recipient.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IOTAToAddress}.
         */
        public String iOTAToAddress() {
            return "IOTAToAddress";
        }

        /**
         * The key index to start search from.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IOTAAddressIndex}.
         */
        public String iOTAAddressIndex() {
            return "IOTAAddressIndex";
        }

        /**
         * The starting key index, must be at least 0.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IOTAAddressStartIndex}.
         */
        public String iOTAAddressStartIndex() {
            return "IOTAAddressStartIndex";
        }

        /**
         * The ending key index, must be bigger then start.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IOTAAddressEndIndex}.
         */
        public String iOTAAddressEndIndex() {
            return "IOTAAddressEndIndex";
        }
    }
    static IOTAEndpointBuilder endpointBuilder(String componentName, String path) {
        class IOTAEndpointBuilderImpl extends AbstractEndpointBuilder implements IOTAEndpointBuilder, AdvancedIOTAEndpointBuilder {
            public IOTAEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new IOTAEndpointBuilderImpl(path);
    }
}