/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.msk.MSK2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.kafka.KafkaClient;

public interface MSK2EndpointBuilderFactory {
    public static MSK2EndpointBuilder endpointBuilder(String componentName, String path) {
        class MSK2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements MSK2EndpointBuilder,
        AdvancedMSK2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public MSK2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new MSK2EndpointBuilderImpl(path, componentName);
    }

    public static class MSK2HeaderNameBuilder {
        private static final MSK2HeaderNameBuilder INSTANCE = new MSK2HeaderNameBuilder();

        public String awsMSKOperation() {
            return "CamelAwsMSKOperation";
        }

        public String awsMSKClusterFilter() {
            return "CamelAwsMSKClusterFilter";
        }

        public String awsMSKClusterName() {
            return "CamelAwsMSKClusterName";
        }

        public String awsMSKClusterArn() {
            return "CamelAwsMSKClusterArn";
        }

        public String awsMSKClusterKafkaVersion() {
            return "CamelAwsMSKClusterKafkaVersion";
        }

        public String awsMSKBrokerNodesNumber() {
            return "CamelAwsMSKBrokerNodesNumber";
        }

        public String awsMSKBrokerNodesGroupInfo() {
            return "CamelAwsMSKBrokerNodesGroupInfo";
        }
    }

    public static interface MSK2Builders {
        default public MSK2HeaderNameBuilder aws2Msk() {
            return MSK2HeaderNameBuilder.INSTANCE;
        }

        default public MSK2EndpointBuilder aws2Msk(String path) {
            return MSK2EndpointBuilderFactory.endpointBuilder("aws2-msk", path);
        }

        default public MSK2EndpointBuilder aws2Msk(String componentName, String path) {
            return MSK2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedMSK2EndpointBuilder
    extends EndpointProducerBuilder {
        default public MSK2EndpointBuilder basic() {
            return (MSK2EndpointBuilder)((Object)this);
        }

        default public AdvancedMSK2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedMSK2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface MSK2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedMSK2EndpointBuilder advanced() {
            return (AdvancedMSK2EndpointBuilder)((Object)this);
        }

        default public MSK2EndpointBuilder mskClient(KafkaClient mskClient) {
            this.doSetProperty("mskClient", mskClient);
            return this;
        }

        default public MSK2EndpointBuilder mskClient(String mskClient) {
            this.doSetProperty("mskClient", mskClient);
            return this;
        }

        default public MSK2EndpointBuilder operation(MSK2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MSK2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public MSK2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public MSK2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public MSK2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MSK2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public MSK2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public MSK2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MSK2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public MSK2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public MSK2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public MSK2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public MSK2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public MSK2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public MSK2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public MSK2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public MSK2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public MSK2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public MSK2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

