/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.aws2.ec2.AWS2EC2Operations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.ec2.Ec2Client;

public interface AWS2EC2EndpointBuilderFactory {
    public static AWS2EC2EndpointBuilder endpointBuilder(String componentName, String path) {
        class AWS2EC2EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements AWS2EC2EndpointBuilder,
        AdvancedAWS2EC2EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public AWS2EC2EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new AWS2EC2EndpointBuilderImpl(path, componentName);
    }

    public static class AWS2EC2HeaderNameBuilder {
        private static final AWS2EC2HeaderNameBuilder INSTANCE = new AWS2EC2HeaderNameBuilder();

        public String awsEC2ImageId() {
            return "CamelAwsEC2ImageId";
        }

        public String awsEC2InstanceType() {
            return "CamelAwsEC2InstanceType";
        }

        public String awsEC2Operation() {
            return "CamelAwsEC2Operation";
        }

        public String awsEC2InstanceMinCount() {
            return "CamelAwsEC2InstanceMinCount";
        }

        public String awsEC2InstanceMaxCount() {
            return "CamelAwsEC2InstanceMaxCount";
        }

        public String awsEC2InstanceMonitoring() {
            return "CamelAwsEC2InstanceMonitoring";
        }

        public String awsEC2InstanceKernelId() {
            return "CamelAwsEC2InstanceKernelId";
        }

        public String awsEC2InstanceEbsOptimized() {
            return "CamelAwsEC2InstanceEbsOptimized";
        }

        public String awsEC2InstanceSecurityGroups() {
            return "CamelAwsEC2InstanceSecurityGroups";
        }

        public String awsEC2InstancesIds() {
            return "CamelAwsEC2InstancesIds";
        }

        public String awsEC2InstancesKeyPair() {
            return "CamelAwsEC2InstancesKeyPair";
        }

        public String awsEC2InstancesClientToken() {
            return "CamelAwsEC2InstancesClientToken";
        }

        public String awsEC2InstancesPlacement() {
            return "CamelAwsEC2InstancesPlacement";
        }

        public String awsEC2InstancesTags() {
            return "CamelAwsEC2InstancesTags";
        }

        public String awsEC2SubnetId() {
            return "CamelAwsEC2SubnetId";
        }
    }

    public static interface AWS2EC2Builders {
        default public AWS2EC2HeaderNameBuilder aws2Ec2() {
            return AWS2EC2HeaderNameBuilder.INSTANCE;
        }

        default public AWS2EC2EndpointBuilder aws2Ec2(String path) {
            return AWS2EC2EndpointBuilderFactory.endpointBuilder("aws2-ec2", path);
        }

        default public AWS2EC2EndpointBuilder aws2Ec2(String componentName, String path) {
            return AWS2EC2EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedAWS2EC2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AWS2EC2EndpointBuilder basic() {
            return (AWS2EC2EndpointBuilder)((Object)this);
        }

        default public AdvancedAWS2EC2EndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedAWS2EC2EndpointBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public static interface AWS2EC2EndpointBuilder
    extends EndpointProducerBuilder {
        default public AdvancedAWS2EC2EndpointBuilder advanced() {
            return (AdvancedAWS2EC2EndpointBuilder)((Object)this);
        }

        default public AWS2EC2EndpointBuilder amazonEc2Client(Ec2Client amazonEc2Client) {
            this.doSetProperty("amazonEc2Client", amazonEc2Client);
            return this;
        }

        default public AWS2EC2EndpointBuilder amazonEc2Client(String amazonEc2Client) {
            this.doSetProperty("amazonEc2Client", amazonEc2Client);
            return this;
        }

        default public AWS2EC2EndpointBuilder operation(AWS2EC2Operations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AWS2EC2EndpointBuilder operation(String operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AWS2EC2EndpointBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AWS2EC2EndpointBuilder overrideEndpoint(String overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AWS2EC2EndpointBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AWS2EC2EndpointBuilder pojoRequest(String pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AWS2EC2EndpointBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AWS2EC2EndpointBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AWS2EC2EndpointBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AWS2EC2EndpointBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AWS2EC2EndpointBuilder proxyPort(String proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AWS2EC2EndpointBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AWS2EC2EndpointBuilder proxyProtocol(String proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AWS2EC2EndpointBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AWS2EC2EndpointBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AWS2EC2EndpointBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AWS2EC2EndpointBuilder sessionToken(String sessionToken) {
            this.doSetProperty("sessionToken", sessionToken);
            return this;
        }

        default public AWS2EC2EndpointBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AWS2EC2EndpointBuilder trustAllCertificates(String trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AWS2EC2EndpointBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AWS2EC2EndpointBuilder useDefaultCredentialsProvider(String useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AWS2EC2EndpointBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AWS2EC2EndpointBuilder useProfileCredentialsProvider(String useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AWS2EC2EndpointBuilder useSessionCredentials(boolean useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }

        default public AWS2EC2EndpointBuilder useSessionCredentials(String useSessionCredentials) {
            this.doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }
}

