/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.endpoint.dsl;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.ExceptionListener;
import java.util.Map;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.jms.JmsMessageType;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.ReplyToType;
import org.apache.camel.component.jms.TemporaryQueueResolver;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

public interface ActiveMQ6EndpointBuilderFactory {
    public static ActiveMQ6EndpointBuilder endpointBuilder(String componentName, String path) {
        class ActiveMQ6EndpointBuilderImpl
        extends AbstractEndpointBuilder
        implements ActiveMQ6EndpointBuilder,
        AdvancedActiveMQ6EndpointBuilder {
            final /* synthetic */ String val$componentName;

            public ActiveMQ6EndpointBuilderImpl(String path, String string) {
                this.val$componentName = string;
                super(string, path);
            }
        }
        return new ActiveMQ6EndpointBuilderImpl(path, componentName);
    }

    public static class ActiveMQ6HeaderNameBuilder {
        private static final ActiveMQ6HeaderNameBuilder INSTANCE = new ActiveMQ6HeaderNameBuilder();

        public String jmsDestination() {
            return "CamelJmsDestination";
        }

        public String jmsDestinationName() {
            return "CamelJmsDestinationName";
        }

        public String jMSDestinationProduced() {
            return "CamelJMSDestinationProduced";
        }

        public String jMSXGroupID() {
            return "JMSXGroupID";
        }

        public String jMSMessageID() {
            return "JMSMessageID";
        }

        public String jMSCorrelationID() {
            return "JMSCorrelationID";
        }

        public String jMSCorrelationIDAsBytes() {
            return "JMSCorrelationIDAsBytes";
        }

        public String jMSDeliveryMode() {
            return "JMSDeliveryMode";
        }

        public String jMSDestination() {
            return "JMSDestination";
        }

        public String jMSExpiration() {
            return "JMSExpiration";
        }

        public String jMSPriority() {
            return "JMSPriority";
        }

        public String jMSRedelivered() {
            return "JMSRedelivered";
        }

        public String jMSTimestamp() {
            return "JMSTimestamp";
        }

        public String jMSReplyTo() {
            return "JMSReplyTo";
        }

        public String jMSType() {
            return "JMSType";
        }

        public String jMSXUserID() {
            return "JMSXUserID";
        }

        public String jmsMessageType() {
            return "CamelJmsMessageType";
        }

        public String jmsRequestTimeout() {
            return "CamelJmsRequestTimeout";
        }
    }

    public static interface ActiveMQ6Builders {
        default public ActiveMQ6HeaderNameBuilder activemq6() {
            return ActiveMQ6HeaderNameBuilder.INSTANCE;
        }

        default public ActiveMQ6EndpointBuilder activemq6(String path) {
            return ActiveMQ6EndpointBuilderFactory.endpointBuilder("activemq6", path);
        }

        default public ActiveMQ6EndpointBuilder activemq6(String componentName, String path) {
            return ActiveMQ6EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    public static interface AdvancedActiveMQ6EndpointBuilder
    extends AdvancedActiveMQ6EndpointConsumerBuilder,
    AdvancedActiveMQ6EndpointProducerBuilder {
        @Override
        default public ActiveMQ6EndpointBuilder basic() {
            return (ActiveMQ6EndpointBuilder)((Object)this);
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder allowSerializedHeaders(String allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder artemisStreamingEnabled(String artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder asyncStartListener(boolean asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder asyncStartListener(String asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder asyncStopListener(boolean asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder asyncStopListener(String asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder browseLimit(int browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder browseLimit(String browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder destinationResolver(DestinationResolver destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder destinationResolver(String destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder errorHandler(ErrorHandler errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder errorHandler(String errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder exceptionListener(ExceptionListener exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder exceptionListener(String exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder idleConsumerLimit(int idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder idleConsumerLimit(String idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder idleReceivesPerTaskLimit(int idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder idleReceivesPerTaskLimit(String idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder idleTaskExecutionLimit(String idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder includeAllJMSXProperties(String includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder jmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder jmsKeyFormatStrategy(String jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder mapJmsMessage(boolean mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder mapJmsMessage(String mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder maxMessagesPerTask(String maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageConverter(MessageConverter messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageConverter(String messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageCreatedStrategy(String messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageIdEnabled(boolean messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageIdEnabled(String messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageListenerContainerFactory(String messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder messageTimestampEnabled(String messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder pubSubNoLocal(String pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder receiveTimeout(long receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder receiveTimeout(String receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder recoveryInterval(long recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder recoveryInterval(String recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder requestTimeoutCheckerInterval(String requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder temporaryQueueResolver(TemporaryQueueResolver temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder temporaryQueueResolver(String temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transferException(String transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transferExchange(String transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder useMessageIDAsCorrelationID(String useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForProvisionCorrelationToBeUpdatedCounter(String waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(String waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForTemporaryReplyToToBeUpdatedCounter(int waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForTemporaryReplyToToBeUpdatedCounter(String waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(long waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(String waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder lazyCreateTransactionManager(String lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transactionManager(PlatformTransactionManager transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transactionManager(String transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transactionName(String transactionName) {
            this.doSetProperty("transactionName", transactionName);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transactionTimeout(int transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }

        @Override
        default public AdvancedActiveMQ6EndpointBuilder transactionTimeout(String transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    public static interface ActiveMQ6EndpointBuilder
    extends ActiveMQ6EndpointConsumerBuilder,
    ActiveMQ6EndpointProducerBuilder {
        @Override
        default public AdvancedActiveMQ6EndpointBuilder advanced() {
            return (AdvancedActiveMQ6EndpointBuilder)((Object)this);
        }

        @Override
        default public ActiveMQ6EndpointBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder connectionFactory(String connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder disableReplyTo(boolean disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder disableReplyTo(String disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder durableSubscriptionName(String durableSubscriptionName) {
            this.doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder jmsMessageType(JmsMessageType jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder jmsMessageType(String jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder testConnectionOnStartup(String testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder transacted(boolean transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder transacted(String transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder transactedInOut(boolean transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }

        @Override
        default public ActiveMQ6EndpointBuilder transactedInOut(String transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    }

    public static interface AdvancedActiveMQ6EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public ActiveMQ6EndpointProducerBuilder basic() {
            return (ActiveMQ6EndpointProducerBuilder)((Object)this);
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder allowAdditionalHeaders(String allowAdditionalHeaders) {
            this.doSetProperty("allowAdditionalHeaders", allowAdditionalHeaders);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder allowNullBody(boolean allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder allowNullBody(String allowNullBody) {
            this.doSetProperty("allowNullBody", allowNullBody);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder alwaysCopyMessage(boolean alwaysCopyMessage) {
            this.doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder alwaysCopyMessage(String alwaysCopyMessage) {
            this.doSetProperty("alwaysCopyMessage", alwaysCopyMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder correlationProperty(String correlationProperty) {
            this.doSetProperty("correlationProperty", correlationProperty);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder disableTimeToLive(boolean disableTimeToLive) {
            this.doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder disableTimeToLive(String disableTimeToLive) {
            this.doSetProperty("disableTimeToLive", disableTimeToLive);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder forceSendOriginalMessage(boolean forceSendOriginalMessage) {
            this.doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder forceSendOriginalMessage(String forceSendOriginalMessage) {
            this.doSetProperty("forceSendOriginalMessage", forceSendOriginalMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder includeSentJMSMessageID(boolean includeSentJMSMessageID) {
            this.doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder includeSentJMSMessageID(String includeSentJMSMessageID) {
            this.doSetProperty("includeSentJMSMessageID", includeSentJMSMessageID);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder replyToCacheLevelName(String replyToCacheLevelName) {
            this.doSetProperty("replyToCacheLevelName", replyToCacheLevelName);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder replyToDestinationSelectorName(String replyToDestinationSelectorName) {
            this.doSetProperty("replyToDestinationSelectorName", replyToDestinationSelectorName);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder streamMessageTypeEnabled(boolean streamMessageTypeEnabled) {
            this.doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder streamMessageTypeEnabled(String streamMessageTypeEnabled) {
            this.doSetProperty("streamMessageTypeEnabled", streamMessageTypeEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder allowSerializedHeaders(String allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder artemisStreamingEnabled(String artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder asyncStartListener(boolean asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder asyncStartListener(String asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder asyncStopListener(boolean asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder asyncStopListener(String asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder browseLimit(int browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder browseLimit(String browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder destinationResolver(DestinationResolver destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder destinationResolver(String destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder errorHandler(ErrorHandler errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder errorHandler(String errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder exceptionListener(ExceptionListener exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder exceptionListener(String exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder idleConsumerLimit(int idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder idleConsumerLimit(String idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder idleReceivesPerTaskLimit(int idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder idleReceivesPerTaskLimit(String idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder idleTaskExecutionLimit(String idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder includeAllJMSXProperties(String includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder jmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder jmsKeyFormatStrategy(String jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder mapJmsMessage(boolean mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder mapJmsMessage(String mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder maxMessagesPerTask(String maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageConverter(MessageConverter messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageConverter(String messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageCreatedStrategy(String messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageIdEnabled(boolean messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageIdEnabled(String messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageListenerContainerFactory(String messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder messageTimestampEnabled(String messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder pubSubNoLocal(String pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder receiveTimeout(long receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder receiveTimeout(String receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder recoveryInterval(long recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder recoveryInterval(String recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder requestTimeoutCheckerInterval(String requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder temporaryQueueResolver(TemporaryQueueResolver temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder temporaryQueueResolver(String temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transferException(String transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transferExchange(String transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder useMessageIDAsCorrelationID(String useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedCounter(String waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(String waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForTemporaryReplyToToBeUpdatedCounter(int waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForTemporaryReplyToToBeUpdatedCounter(String waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(long waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(String waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder lazyCreateTransactionManager(String lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transactionManager(PlatformTransactionManager transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transactionManager(String transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transactionName(String transactionName) {
            this.doSetProperty("transactionName", transactionName);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transactionTimeout(int transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }

        default public AdvancedActiveMQ6EndpointProducerBuilder transactionTimeout(String transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    public static interface ActiveMQ6EndpointProducerBuilder
    extends EndpointProducerBuilder {
        default public AdvancedActiveMQ6EndpointProducerBuilder advanced() {
            return (AdvancedActiveMQ6EndpointProducerBuilder)((Object)this);
        }

        default public ActiveMQ6EndpointProducerBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder connectionFactory(String connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder disableReplyTo(boolean disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder disableReplyTo(String disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder durableSubscriptionName(String durableSubscriptionName) {
            this.doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder jmsMessageType(JmsMessageType jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder jmsMessageType(String jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder testConnectionOnStartup(String testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder deliveryDelay(long deliveryDelay) {
            this.doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder deliveryDelay(String deliveryDelay) {
            this.doSetProperty("deliveryDelay", deliveryDelay);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder deliveryMode(Integer deliveryMode) {
            this.doSetProperty("deliveryMode", deliveryMode);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder deliveryMode(String deliveryMode) {
            this.doSetProperty("deliveryMode", deliveryMode);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder deliveryPersistent(boolean deliveryPersistent) {
            this.doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder deliveryPersistent(String deliveryPersistent) {
            this.doSetProperty("deliveryPersistent", deliveryPersistent);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder explicitQosEnabled(Boolean explicitQosEnabled) {
            this.doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder explicitQosEnabled(String explicitQosEnabled) {
            this.doSetProperty("explicitQosEnabled", explicitQosEnabled);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder formatDateHeadersToIso8601(boolean formatDateHeadersToIso8601) {
            this.doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder formatDateHeadersToIso8601(String formatDateHeadersToIso8601) {
            this.doSetProperty("formatDateHeadersToIso8601", formatDateHeadersToIso8601);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder preserveMessageQos(boolean preserveMessageQos) {
            this.doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder preserveMessageQos(String preserveMessageQos) {
            this.doSetProperty("preserveMessageQos", preserveMessageQos);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder priority(int priority) {
            this.doSetProperty("priority", priority);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder priority(String priority) {
            this.doSetProperty("priority", priority);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToConcurrentConsumers(int replyToConcurrentConsumers) {
            this.doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToConcurrentConsumers(String replyToConcurrentConsumers) {
            this.doSetProperty("replyToConcurrentConsumers", replyToConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToMaxConcurrentConsumers(int replyToMaxConcurrentConsumers) {
            this.doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToMaxConcurrentConsumers(String replyToMaxConcurrentConsumers) {
            this.doSetProperty("replyToMaxConcurrentConsumers", replyToMaxConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToOnTimeoutMaxConcurrentConsumers(int replyToOnTimeoutMaxConcurrentConsumers) {
            this.doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToOnTimeoutMaxConcurrentConsumers(String replyToOnTimeoutMaxConcurrentConsumers) {
            this.doSetProperty("replyToOnTimeoutMaxConcurrentConsumers", replyToOnTimeoutMaxConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToOverride(String replyToOverride) {
            this.doSetProperty("replyToOverride", replyToOverride);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToType(ReplyToType replyToType) {
            this.doSetProperty("replyToType", replyToType);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder replyToType(String replyToType) {
            this.doSetProperty("replyToType", replyToType);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder requestTimeout(long requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder requestTimeout(String requestTimeout) {
            this.doSetProperty("requestTimeout", requestTimeout);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder timeToLive(long timeToLive) {
            this.doSetProperty("timeToLive", timeToLive);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder timeToLive(String timeToLive) {
            this.doSetProperty("timeToLive", timeToLive);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder transacted(boolean transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder transacted(String transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder transactedInOut(boolean transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }

        default public ActiveMQ6EndpointProducerBuilder transactedInOut(String transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    }

    public static interface AdvancedActiveMQ6EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public ActiveMQ6EndpointConsumerBuilder basic() {
            return (ActiveMQ6EndpointConsumerBuilder)((Object)this);
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder acceptMessagesWhileStopping(boolean acceptMessagesWhileStopping) {
            this.doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder acceptMessagesWhileStopping(String acceptMessagesWhileStopping) {
            this.doSetProperty("acceptMessagesWhileStopping", acceptMessagesWhileStopping);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder allowReplyManagerQuickStop(boolean allowReplyManagerQuickStop) {
            this.doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder allowReplyManagerQuickStop(String allowReplyManagerQuickStop) {
            this.doSetProperty("allowReplyManagerQuickStop", allowReplyManagerQuickStop);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder consumerType(ConsumerType consumerType) {
            this.doSetProperty("consumerType", consumerType);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder consumerType(String consumerType) {
            this.doSetProperty("consumerType", consumerType);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder defaultTaskExecutorType(DefaultTaskExecutorType defaultTaskExecutorType) {
            this.doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder defaultTaskExecutorType(String defaultTaskExecutorType) {
            this.doSetProperty("defaultTaskExecutorType", defaultTaskExecutorType);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder destinationOptions(String key, Object value) {
            this.doSetMultiValueProperty("destinationOptions", "destination." + key, value);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder destinationOptions(Map values) {
            this.doSetMultiValueProperties("destinationOptions", "destination.", values);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder eagerLoadingOfProperties(boolean eagerLoadingOfProperties) {
            this.doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder eagerLoadingOfProperties(String eagerLoadingOfProperties) {
            this.doSetProperty("eagerLoadingOfProperties", eagerLoadingOfProperties);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder eagerPoisonBody(String eagerPoisonBody) {
            this.doSetProperty("eagerPoisonBody", eagerPoisonBody);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exceptionHandler(ExceptionHandler exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            this.doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exchangePattern(ExchangePattern exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exchangePattern(String exchangePattern) {
            this.doSetProperty("exchangePattern", exchangePattern);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exposeListenerSession(boolean exposeListenerSession) {
            this.doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exposeListenerSession(String exposeListenerSession) {
            this.doSetProperty("exposeListenerSession", exposeListenerSession);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder replyToConsumerType(ConsumerType replyToConsumerType) {
            this.doSetProperty("replyToConsumerType", replyToConsumerType);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder replyToConsumerType(String replyToConsumerType) {
            this.doSetProperty("replyToConsumerType", replyToConsumerType);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder replyToSameDestinationAllowed(boolean replyToSameDestinationAllowed) {
            this.doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder replyToSameDestinationAllowed(String replyToSameDestinationAllowed) {
            this.doSetProperty("replyToSameDestinationAllowed", replyToSameDestinationAllowed);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder taskExecutor(TaskExecutor taskExecutor) {
            this.doSetProperty("taskExecutor", taskExecutor);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder taskExecutor(String taskExecutor) {
            this.doSetProperty("taskExecutor", taskExecutor);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder allowSerializedHeaders(boolean allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder allowSerializedHeaders(String allowSerializedHeaders) {
            this.doSetProperty("allowSerializedHeaders", allowSerializedHeaders);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder artemisStreamingEnabled(boolean artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder artemisStreamingEnabled(String artemisStreamingEnabled) {
            this.doSetProperty("artemisStreamingEnabled", artemisStreamingEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder asyncStartListener(boolean asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder asyncStartListener(String asyncStartListener) {
            this.doSetProperty("asyncStartListener", asyncStartListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder asyncStopListener(boolean asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder asyncStopListener(String asyncStopListener) {
            this.doSetProperty("asyncStopListener", asyncStopListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder browseLimit(int browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder browseLimit(String browseLimit) {
            this.doSetProperty("browseLimit", browseLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder destinationResolver(DestinationResolver destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder destinationResolver(String destinationResolver) {
            this.doSetProperty("destinationResolver", destinationResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder errorHandler(ErrorHandler errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder errorHandler(String errorHandler) {
            this.doSetProperty("errorHandler", errorHandler);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exceptionListener(ExceptionListener exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder exceptionListener(String exceptionListener) {
            this.doSetProperty("exceptionListener", exceptionListener);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder headerFilterStrategy(String headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder idleConsumerLimit(int idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder idleConsumerLimit(String idleConsumerLimit) {
            this.doSetProperty("idleConsumerLimit", idleConsumerLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder idleReceivesPerTaskLimit(int idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder idleReceivesPerTaskLimit(String idleReceivesPerTaskLimit) {
            this.doSetProperty("idleReceivesPerTaskLimit", idleReceivesPerTaskLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder idleTaskExecutionLimit(int idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder idleTaskExecutionLimit(String idleTaskExecutionLimit) {
            this.doSetProperty("idleTaskExecutionLimit", idleTaskExecutionLimit);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder includeAllJMSXProperties(boolean includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder includeAllJMSXProperties(String includeAllJMSXProperties) {
            this.doSetProperty("includeAllJMSXProperties", includeAllJMSXProperties);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder jmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder jmsKeyFormatStrategy(String jmsKeyFormatStrategy) {
            this.doSetProperty("jmsKeyFormatStrategy", jmsKeyFormatStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder mapJmsMessage(boolean mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder mapJmsMessage(String mapJmsMessage) {
            this.doSetProperty("mapJmsMessage", mapJmsMessage);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder maxMessagesPerTask(int maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder maxMessagesPerTask(String maxMessagesPerTask) {
            this.doSetProperty("maxMessagesPerTask", maxMessagesPerTask);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageConverter(MessageConverter messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageConverter(String messageConverter) {
            this.doSetProperty("messageConverter", messageConverter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageCreatedStrategy(String messageCreatedStrategy) {
            this.doSetProperty("messageCreatedStrategy", messageCreatedStrategy);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageIdEnabled(boolean messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageIdEnabled(String messageIdEnabled) {
            this.doSetProperty("messageIdEnabled", messageIdEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageListenerContainerFactory(MessageListenerContainerFactory messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageListenerContainerFactory(String messageListenerContainerFactory) {
            this.doSetProperty("messageListenerContainerFactory", messageListenerContainerFactory);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageTimestampEnabled(boolean messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder messageTimestampEnabled(String messageTimestampEnabled) {
            this.doSetProperty("messageTimestampEnabled", messageTimestampEnabled);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder pubSubNoLocal(boolean pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder pubSubNoLocal(String pubSubNoLocal) {
            this.doSetProperty("pubSubNoLocal", pubSubNoLocal);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder receiveTimeout(long receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder receiveTimeout(String receiveTimeout) {
            this.doSetProperty("receiveTimeout", receiveTimeout);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder recoveryInterval(long recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder recoveryInterval(String recoveryInterval) {
            this.doSetProperty("recoveryInterval", recoveryInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder requestTimeoutCheckerInterval(long requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder requestTimeoutCheckerInterval(String requestTimeoutCheckerInterval) {
            this.doSetProperty("requestTimeoutCheckerInterval", requestTimeoutCheckerInterval);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder synchronous(String synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder temporaryQueueResolver(TemporaryQueueResolver temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder temporaryQueueResolver(String temporaryQueueResolver) {
            this.doSetProperty("temporaryQueueResolver", temporaryQueueResolver);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transferException(boolean transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transferException(String transferException) {
            this.doSetProperty("transferException", transferException);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transferExchange(boolean transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transferExchange(String transferExchange) {
            this.doSetProperty("transferExchange", transferExchange);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder useMessageIDAsCorrelationID(boolean useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder useMessageIDAsCorrelationID(String useMessageIDAsCorrelationID) {
            this.doSetProperty("useMessageIDAsCorrelationID", useMessageIDAsCorrelationID);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedCounter(int waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedCounter(String waitForProvisionCorrelationToBeUpdatedCounter) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedCounter", waitForProvisionCorrelationToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForProvisionCorrelationToBeUpdatedThreadSleepingTime(String waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForProvisionCorrelationToBeUpdatedThreadSleepingTime", waitForProvisionCorrelationToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForTemporaryReplyToToBeUpdatedCounter(int waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForTemporaryReplyToToBeUpdatedCounter(String waitForTemporaryReplyToToBeUpdatedCounter) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedCounter", waitForTemporaryReplyToToBeUpdatedCounter);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(long waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder waitForTemporaryReplyToToBeUpdatedThreadSleepingTime(String waitForTemporaryReplyToToBeUpdatedThreadSleepingTime) {
            this.doSetProperty("waitForTemporaryReplyToToBeUpdatedThreadSleepingTime", waitForTemporaryReplyToToBeUpdatedThreadSleepingTime);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder lazyCreateTransactionManager(boolean lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder lazyCreateTransactionManager(String lazyCreateTransactionManager) {
            this.doSetProperty("lazyCreateTransactionManager", lazyCreateTransactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transactionManager(PlatformTransactionManager transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transactionManager(String transactionManager) {
            this.doSetProperty("transactionManager", transactionManager);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transactionName(String transactionName) {
            this.doSetProperty("transactionName", transactionName);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transactionTimeout(int transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }

        default public AdvancedActiveMQ6EndpointConsumerBuilder transactionTimeout(String transactionTimeout) {
            this.doSetProperty("transactionTimeout", transactionTimeout);
            return this;
        }
    }

    public static interface ActiveMQ6EndpointConsumerBuilder
    extends EndpointConsumerBuilder {
        default public AdvancedActiveMQ6EndpointConsumerBuilder advanced() {
            return (AdvancedActiveMQ6EndpointConsumerBuilder)((Object)this);
        }

        default public ActiveMQ6EndpointConsumerBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder connectionFactory(ConnectionFactory connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder connectionFactory(String connectionFactory) {
            this.doSetProperty("connectionFactory", connectionFactory);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder disableReplyTo(boolean disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder disableReplyTo(String disableReplyTo) {
            this.doSetProperty("disableReplyTo", disableReplyTo);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder durableSubscriptionName(String durableSubscriptionName) {
            this.doSetProperty("durableSubscriptionName", durableSubscriptionName);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder jmsMessageType(JmsMessageType jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder jmsMessageType(String jmsMessageType) {
            this.doSetProperty("jmsMessageType", jmsMessageType);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder replyTo(String replyTo) {
            this.doSetProperty("replyTo", replyTo);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder testConnectionOnStartup(boolean testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder testConnectionOnStartup(String testConnectionOnStartup) {
            this.doSetProperty("testConnectionOnStartup", testConnectionOnStartup);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder acknowledgementModeName(String acknowledgementModeName) {
            this.doSetProperty("acknowledgementModeName", acknowledgementModeName);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder artemisConsumerPriority(int artemisConsumerPriority) {
            this.doSetProperty("artemisConsumerPriority", artemisConsumerPriority);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder artemisConsumerPriority(String artemisConsumerPriority) {
            this.doSetProperty("artemisConsumerPriority", artemisConsumerPriority);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder asyncConsumer(boolean asyncConsumer) {
            this.doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder asyncConsumer(String asyncConsumer) {
            this.doSetProperty("asyncConsumer", asyncConsumer);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder autoStartup(boolean autoStartup) {
            this.doSetProperty("autoStartup", autoStartup);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder autoStartup(String autoStartup) {
            this.doSetProperty("autoStartup", autoStartup);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder cacheLevel(int cacheLevel) {
            this.doSetProperty("cacheLevel", cacheLevel);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder cacheLevel(String cacheLevel) {
            this.doSetProperty("cacheLevel", cacheLevel);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder cacheLevelName(String cacheLevelName) {
            this.doSetProperty("cacheLevelName", cacheLevelName);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder concurrentConsumers(int concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder concurrentConsumers(String concurrentConsumers) {
            this.doSetProperty("concurrentConsumers", concurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder maxConcurrentConsumers(int maxConcurrentConsumers) {
            this.doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder maxConcurrentConsumers(String maxConcurrentConsumers) {
            this.doSetProperty("maxConcurrentConsumers", maxConcurrentConsumers);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder replyToDeliveryPersistent(boolean replyToDeliveryPersistent) {
            this.doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder replyToDeliveryPersistent(String replyToDeliveryPersistent) {
            this.doSetProperty("replyToDeliveryPersistent", replyToDeliveryPersistent);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder selector(String selector) {
            this.doSetProperty("selector", selector);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder subscriptionDurable(boolean subscriptionDurable) {
            this.doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder subscriptionDurable(String subscriptionDurable) {
            this.doSetProperty("subscriptionDurable", subscriptionDurable);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder subscriptionName(String subscriptionName) {
            this.doSetProperty("subscriptionName", subscriptionName);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder subscriptionShared(boolean subscriptionShared) {
            this.doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder subscriptionShared(String subscriptionShared) {
            this.doSetProperty("subscriptionShared", subscriptionShared);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder errorHandlerLoggingLevel(LoggingLevel errorHandlerLoggingLevel) {
            this.doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder errorHandlerLoggingLevel(String errorHandlerLoggingLevel) {
            this.doSetProperty("errorHandlerLoggingLevel", errorHandlerLoggingLevel);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder errorHandlerLogStackTrace(boolean errorHandlerLogStackTrace) {
            this.doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder errorHandlerLogStackTrace(String errorHandlerLogStackTrace) {
            this.doSetProperty("errorHandlerLogStackTrace", errorHandlerLogStackTrace);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder password(String password) {
            this.doSetProperty("password", password);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder username(String username) {
            this.doSetProperty("username", username);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder transacted(boolean transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder transacted(String transacted) {
            this.doSetProperty("transacted", transacted);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder transactedInOut(boolean transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }

        default public ActiveMQ6EndpointConsumerBuilder transactedInOut(String transactedInOut) {
            this.doSetProperty("transactedInOut", transactedInOut);
            return this;
        }
    }
}

