/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import mousio.etcd4j.responses.EtcdException;
import mousio.etcd4j.responses.EtcdKeysResponse;
import org.apache.camel.CamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EtcdHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdHelper.class);
    private static final String OUTDATED_EVENT_MSG = "requested index is outdated and cleared";

    private EtcdHelper() {
    }

    public static boolean isOutdatedIndexException(EtcdException exception) {
        if (exception.isErrorCode(401) && exception.etcdMessage != null) {
            return exception.etcdMessage.toLowerCase().contains(OUTDATED_EVENT_MSG);
        }
        return false;
    }

    public static ObjectMapper createObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static void setIndex(AtomicLong index, EtcdKeysResponse response) {
        if (response != null && response.node != null) {
            index.set(response.node.modifiedIndex + 1L);
            LOGGER.debug("Index received={}, next={}", (Object)response.node.modifiedIndex, (Object)index.get());
        } else {
            index.set(response.etcdIndex + 1L);
            LOGGER.debug("Index received={}, next={}", (Object)response.node.modifiedIndex, (Object)index.get());
        }
    }

    public static URI[] resolveURIs(CamelContext camelContext, String uriList) throws Exception {
        String[] uris = uriList != null ? uriList.split(",") : "http://localhost:2379,http://localhost:4001".split(",");
        URI[] etcdUriList = new URI[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            etcdUriList[i] = camelContext != null ? URI.create(camelContext.resolvePropertyPlaceholders(uris[i])) : URI.create(uris[i]);
        }
        return etcdUriList;
    }
}

