/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import mousio.etcd4j.EtcdClient;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.etcd.AbstractEtcdComponent;
import org.apache.camel.component.etcd.AbstractEtcdPollingEndpoint;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.component.etcd.EtcdStatsConsumer;
import org.apache.camel.component.etcd.EtcdStatsProducer;
import org.apache.camel.spi.UriEndpoint;

@UriEndpoint(firstVersion="2.18.0", scheme="etcd-stats", title="Etcd Stats", syntax="etcd-stats:path", label="clustering,database")
public class EtcdStatsEndpoint
extends AbstractEtcdPollingEndpoint {
    public EtcdStatsEndpoint(String uri, AbstractEtcdComponent component, EtcdConfiguration configuration, String path) {
        super(uri, component, configuration, path);
    }

    public Producer createProducer() throws Exception {
        return new EtcdStatsProducer(this, this.getConfiguration(), this.getPath());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        EtcdStatsConsumer consumer = new EtcdStatsConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    Object getStats(EtcdClient client) {
        switch (this.getPath()) {
            case "/leader": {
                return client.getLeaderStats();
            }
            case "/self": {
                return client.getSelfStats();
            }
            case "/store": {
                return client.getStoreStats();
            }
        }
        throw new IllegalStateException("No stats for " + this.getPath());
    }
}

