/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.etcd.EtcdConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

public abstract class AbstractEtcdComponent
extends DefaultComponent
implements SSLContextParametersAware {
    @Metadata
    private EtcdConfiguration configuration = new EtcdConfiguration();
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public AbstractEtcdComponent() {
    }

    public AbstractEtcdComponent(CamelContext context) {
        super(context);
    }

    public EtcdConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(EtcdConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    protected EtcdConfiguration loadConfiguration(Map<String, Object> parameters) {
        EtcdConfiguration configuration = Optional.ofNullable(this.configuration).orElseGet(EtcdConfiguration::new).copy();
        configuration.setCamelContext(this.getCamelContext());
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return configuration;
    }
}

