/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3.cloud;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.options.WatchOption;
import io.etcd.jetcd.watch.WatchResponse;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.component.etcd3.Etcd3Configuration;
import org.apache.camel.component.etcd3.Etcd3Helper;
import org.apache.camel.component.etcd3.cloud.Etcd3GetServicesResponse;
import org.apache.camel.component.etcd3.cloud.Etcd3ServiceDiscovery;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Etcd3WatchServiceDiscovery
extends Etcd3ServiceDiscovery
implements Watch.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(Etcd3WatchServiceDiscovery.class);
    private volatile List<ServiceDefinition> allServices;
    private final AtomicLong revision;
    private final String servicePath;
    private final Client client;
    private final Watch watch;
    private final Charset keyCharset;
    private final AtomicReference<Watch.Watcher> watcher = new AtomicReference();

    public Etcd3WatchServiceDiscovery(Etcd3Configuration configuration) {
        super(configuration);
        this.revision = new AtomicLong();
        this.servicePath = (String)ObjectHelper.notNull((Object)configuration.getServicePath(), (String)"servicePath");
        this.client = configuration.createClient();
        this.watch = this.client.getWatchClient();
        this.keyCharset = Charset.forName(configuration.getKeyCharset());
    }

    @Override
    protected void doStop() throws Exception {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        finally {
            super.doStop();
        }
    }

    public List<ServiceDefinition> getServices(String name) {
        List<ServiceDefinition> servers = this.allServices;
        if (servers == null) {
            this.lock.lock();
            try {
                servers = this.allServices;
                if (servers == null) {
                    servers = this.reloadServices();
                    this.doWatch();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return servers.stream().filter(s -> name.equalsIgnoreCase(s.getName())).collect(Collectors.toList());
    }

    private List<ServiceDefinition> reloadServices() {
        Etcd3GetServicesResponse response = this.findServices();
        this.revision.getAndUpdate(r -> Math.max(r, response.getRevision() + 1L));
        this.allServices = response.getServices();
        return response.getServices();
    }

    private void doWatch() {
        if (!this.isRunAllowed()) {
            return;
        }
        this.watcher.getAndUpdate(w -> {
            if (w != null) {
                w.close();
            }
            return this.watch.watch(ByteSequence.from((String)Etcd3Helper.toPathPrefix(this.servicePath), (Charset)this.keyCharset), WatchOption.newBuilder().isPrefix(true).withRevision(this.revision.get()).build(), (Watch.Listener)this);
        });
    }

    public void onNext(WatchResponse response) {
        this.reloadServices();
    }

    public void onError(Throwable throwable) {
        LOGGER.debug("Cloud not fetch the index, key={}, cause={}", (Object)this.servicePath, (Object)throwable);
    }

    public void onCompleted() {
        this.doWatch();
    }
}

