/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.client;

import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.example.reportincident.InputReportIncident;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class CamelClient {
    private static final int SIZE = 100;

    private CamelClient() {
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Notice this client requires that the CamelServer is already running!");
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("META-INF/spring/camel-client.xml");
        ProducerTemplate producer = (ProducerTemplate)context.getBean("camelTemplate");
        MockEndpoint mock = (MockEndpoint)context.getBean("result");
        mock.expectedMessageCount(100);
        mock.expectsNoDuplicates().body();
        System.out.println("Sending ...");
        for (int i = 0; i < 100; ++i) {
            InputReportIncident input = new InputReportIncident();
            input.setIncidentId("" + i);
            input.setIncidentDate("20091116");
            input.setGivenName("Claus");
            input.setFamilyName("Ibsen");
            input.setSummary("Camel rocks");
            input.setDetails("More bla");
            input.setEmail("davsclaus@apache.org");
            input.setPhone("55512345678");
            producer.sendBody("direct:start", (Object)input);
        }
        System.out.println("... Send done");
        System.out.println("Asserting ...");
        mock.assertIsSatisfied();
        System.out.println("... Asserting done");
        System.exit(0);
    }
}

