/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.tracer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.processor.aggregate.AggregationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuoteAggregator
implements AggregationStrategy {
    private List<String> coolWords = new ArrayList<String>();

    public void setCoolWords(List<String> coolWords) {
        for (String s : coolWords) {
            this.coolWords.add(s.toLowerCase());
        }
        Collections.reverse(this.coolWords);
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        String newQuote;
        if (oldExchange == null) {
            return newExchange;
        }
        String oldQuote = (String)oldExchange.getIn().getBody(String.class);
        int result = new QuoteComparator().compare(oldQuote, newQuote = (String)newExchange.getIn().getBody(String.class));
        return result > 0 ? newExchange : oldExchange;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QuoteComparator
    implements Comparator<String> {
        private QuoteComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int index1 = QuoteAggregator.this.coolWords.indexOf(o1.toLowerCase());
            int index2 = QuoteAggregator.this.coolWords.indexOf(o2.toLowerCase());
            return index1 - index2;
        }
    }
}

