/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.LoggingLevel;
import org.apache.camel.util.ObjectHelper;

public class ExecCommand
implements Serializable {
    private static final long serialVersionUID = 1755094616849607573L;
    private final String executable;
    private final Set<Integer> exitValues;
    private final List<String> args;
    private final String workingDir;
    private final long timeout;
    private final File outFile;
    private final InputStream input;
    private final LoggingLevel commandLogLevel;
    private final boolean useStderrOnEmptyStdout;

    public ExecCommand(String executable, List<String> args, String workingDir, Long timeout, Set<Integer> exitValues, InputStream input, File outFile, boolean useStderrOnEmptyStdout, LoggingLevel commandLogLevel) {
        ObjectHelper.notNull((Object)executable, (String)"command executable");
        this.executable = executable;
        this.exitValues = exitValues;
        this.args = this.unmodifiableOrEmptyList(args);
        this.workingDir = workingDir;
        this.timeout = timeout;
        this.input = input;
        this.outFile = outFile;
        this.useStderrOnEmptyStdout = useStderrOnEmptyStdout;
        this.commandLogLevel = commandLogLevel;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getExecutable() {
        return this.executable;
    }

    public Set<Integer> getExitValues() {
        return this.exitValues;
    }

    public InputStream getInput() {
        return this.input;
    }

    public File getOutFile() {
        return this.outFile;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isUseStderrOnEmptyStdout() {
        return this.useStderrOnEmptyStdout;
    }

    public LoggingLevel getCommandLogLevel() {
        return this.commandLogLevel;
    }

    public String toString() {
        String dirToPrint = this.workingDir == null ? "null" : this.workingDir;
        String outFileToPrint = this.outFile == null ? "null" : this.outFile.getPath();
        String exitValuesString = this.exitValues.stream().map(Object::toString).collect(Collectors.joining(","));
        return "ExecCommand [args=" + this.args + ", executable=" + this.executable + ", timeout=" + this.timeout + ", exitValues=" + exitValuesString + ", outFile=" + outFileToPrint + ", workingDir=" + dirToPrint + ", commandLogLevel=" + this.commandLogLevel + ", useStderrOnEmptyStdout=" + this.useStderrOnEmptyStdout + "]";
    }

    private <T> List<T> unmodifiableOrEmptyList(List<T> list) {
        return Collections.unmodifiableList(list == null ? new ArrayList() : list);
    }
}

