/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.exec.ExecBinding;
import org.apache.camel.component.exec.ExecCommandExecutor;
import org.apache.camel.component.exec.ExecComponent;
import org.apache.camel.component.exec.ExecProducer;
import org.apache.camel.component.exec.impl.DefaultExecBinding;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="2.3.0", scheme="exec", title="Exec", syntax="exec:executable", producerOnly=true, remote=false, category={Category.CORE}, headersClass=ExecBinding.class)
public class ExecEndpoint
extends DefaultEndpoint {
    public static final long NO_TIMEOUT = Long.MAX_VALUE;
    @UriPath
    @Metadata(required=true)
    private String executable;
    @UriParam
    private String args;
    @UriParam
    private String workingDir;
    @UriParam(javaType="java.time.Duration")
    private long timeout;
    @UriParam
    private String exitValues;
    @UriParam
    private String outFile;
    @UriParam
    private ExecCommandExecutor commandExecutor;
    @UriParam
    private ExecBinding binding;
    @UriParam
    private boolean useStderrOnEmptyStdout;
    @UriParam(defaultValue="DEBUG")
    private LoggingLevel commandLogLevel = LoggingLevel.DEBUG;

    public ExecEndpoint(String uri, ExecComponent component) {
        super(uri, (Component)component);
        this.timeout = Long.MAX_VALUE;
        this.binding = new DefaultExecBinding();
    }

    public boolean isRemote() {
        return false;
    }

    public Producer createProducer() throws Exception {
        return new ExecProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for ExecEndpoint!");
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        StringHelper.notEmpty((String)executable, (String)"executable");
        this.executable = executable;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String dir) {
        this.workingDir = dir;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("The timeout must be a positive long!");
        }
        this.timeout = timeout;
    }

    public String getExitValues() {
        return this.exitValues;
    }

    public void setExitValues(String exitValues) {
        this.exitValues = exitValues;
    }

    public String getOutFile() {
        return this.outFile;
    }

    public void setOutFile(String outFile) {
        StringHelper.notEmpty((String)outFile, (String)"outFile");
        this.outFile = outFile;
    }

    public ExecCommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public void setCommandExecutor(ExecCommandExecutor commandExecutor) {
        ObjectHelper.notNull((Object)commandExecutor, (String)"commandExecutor");
        this.commandExecutor = commandExecutor;
    }

    public ExecBinding getBinding() {
        return this.binding;
    }

    public void setBinding(ExecBinding binding) {
        ObjectHelper.notNull((Object)binding, (String)"binding");
        this.binding = binding;
    }

    public boolean isUseStderrOnEmptyStdout() {
        return this.useStderrOnEmptyStdout;
    }

    public void setUseStderrOnEmptyStdout(boolean useStderrOnEmptyStdout) {
        this.useStderrOnEmptyStdout = useStderrOnEmptyStdout;
    }

    public LoggingLevel getCommandLogLevel() {
        return this.commandLogLevel;
    }

    public void setCommandLogLevel(LoggingLevel commandLogLevel) {
        this.commandLogLevel = commandLogLevel;
    }
}

