/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.facebook.data;

import facebook4j.Reading;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.facebook.config.FacebookConfiguration;
import org.apache.camel.component.facebook.config.FacebookEndpointConfiguration;
import org.apache.camel.component.facebook.data.ReadingBuilder;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FacebookPropertiesHelper {
    private static final Set<String> COMPONENT_CONFIG_FIELDS = new HashSet<String>();
    private static final Logger LOG = LoggerFactory.getLogger(FacebookPropertiesHelper.class);
    private static final Set<String> ENDPOINT_CONFIG_FIELDS = new HashSet<String>();

    private FacebookPropertiesHelper() {
    }

    public static void configureReadingProperties(FacebookEndpointConfiguration configuration, Map<String, Object> options) {
        Map readingProperties = PropertiesHelper.extractProperties(options, (String)"reading.");
        if (!readingProperties.isEmpty()) {
            try {
                Reading reading = configuration.getReading();
                if (reading != null) {
                    Reading readingUpdate = new Reading();
                    ReadingBuilder.setProperties(readingUpdate, readingProperties);
                    reading = ReadingBuilder.merge(reading, readingUpdate);
                } else {
                    reading = new Reading();
                    ReadingBuilder.setProperties(reading, readingProperties);
                }
                ReadingBuilder.setProperties(reading, readingProperties);
                configuration.setReading(reading);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(readingProperties.toString(), e);
            }
            for (Map.Entry entry : readingProperties.entrySet()) {
                options.put("reading." + (String)entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> getExchangeProperties(Exchange exchange, Map<String, Object> properties) {
        int nProperties = 0;
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            if (!((String)entry.getKey()).startsWith("CamelFacebook.")) continue;
            properties.put(((String)entry.getKey()).substring("CamelFacebook.".length()), entry.getValue());
            ++nProperties;
        }
        LOG.debug("Found {} properties in exchange", (Object)nProperties);
        return properties;
    }

    public static void getEndpointProperties(CamelContext camelContext, FacebookEndpointConfiguration configuration, Map<String, Object> properties) {
        Set<String> names;
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection((CamelContext)camelContext);
        if (beanIntrospection.getProperties((Object)configuration, properties, null, false)) {
            names = properties.keySet();
            names.removeAll(COMPONENT_CONFIG_FIELDS);
        }
        if (LOG.isDebugEnabled()) {
            names = properties.keySet();
            LOG.debug("Found endpoint properties {}", (Object)names.retainAll(ENDPOINT_CONFIG_FIELDS));
        }
    }

    public static Set<String> getEndpointPropertyNames(CamelContext camelContext, FacebookEndpointConfiguration configuration) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        FacebookPropertiesHelper.getEndpointProperties(camelContext, configuration, properties);
        return Collections.unmodifiableSet(properties.keySet());
    }

    public static Set<String> getValidEndpointProperties() {
        return Collections.unmodifiableSet(ENDPOINT_CONFIG_FIELDS);
    }

    static {
        for (Field field : FacebookConfiguration.class.getDeclaredFields()) {
            COMPONENT_CONFIG_FIELDS.add(field.getName());
        }
        for (Field field : FacebookEndpointConfiguration.class.getDeclaredFields()) {
            ENDPOINT_CONFIG_FIELDS.add(field.getName());
        }
    }
}

