/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.api;

import ca.uhn.fhir.rest.api.CacheControlDirective;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.gclient.IClientExecutable;
import java.util.List;
import java.util.Map;

public enum ExtraParameters {
    ENCODE_JSON("encodeJson"),
    ENCODE_XML("encodeXml"),
    CACHE_CONTROL_DIRECTIVE("cacheControlDirective"),
    SUBSET_ELEMENTS("subsetElements"),
    ENCODING_ENUM("encodingEnum"),
    PREFER_RESPONSE_TYPE("preferredResponseType"),
    PREFER_RESPONSE_TYPES("preferredResponseTypes"),
    PRETTY_PRINT("prettyPrint"),
    SUMMARY_ENUM("summaryEnum");

    private final String param;
    private final String headerName;

    private ExtraParameters(String param) {
        this.param = param;
        this.headerName = "CamelFhir." + param;
    }

    public String getParam() {
        return this.param;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    static <T extends IClientExecutable<?, ?>> void process(Map<ExtraParameters, Object> extraParameters, T clientExecutable) {
        if (extraParameters == null) {
            return;
        }
        block11: for (Map.Entry<ExtraParameters, Object> entry : extraParameters.entrySet()) {
            switch (entry.getKey().ordinal()) {
                case 0: {
                    Boolean encode = (Boolean)extraParameters.get((Object)ENCODE_JSON);
                    if (!Boolean.TRUE.equals(encode)) continue block11;
                    clientExecutable.encodedJson();
                    continue block11;
                }
                case 1: {
                    Boolean encodeXml = (Boolean)extraParameters.get((Object)ENCODE_XML);
                    if (!Boolean.TRUE.equals(encodeXml)) continue block11;
                    clientExecutable.encodedXml();
                    continue block11;
                }
                case 2: {
                    CacheControlDirective cacheControlDirective = (CacheControlDirective)extraParameters.get((Object)CACHE_CONTROL_DIRECTIVE);
                    clientExecutable.cacheControl(cacheControlDirective);
                    continue block11;
                }
                case 3: {
                    String[] subsetElements = (String[])extraParameters.get((Object)SUBSET_ELEMENTS);
                    clientExecutable.elementsSubset(subsetElements);
                    continue block11;
                }
                case 4: {
                    EncodingEnum encodingEnum = (EncodingEnum)extraParameters.get((Object)ENCODING_ENUM);
                    clientExecutable.encoded(encodingEnum);
                    continue block11;
                }
                case 5: {
                    Class type = (Class)extraParameters.get((Object)PREFER_RESPONSE_TYPE);
                    clientExecutable.preferResponseType(type);
                    continue block11;
                }
                case 6: {
                    List types = (List)extraParameters.get((Object)PREFER_RESPONSE_TYPES);
                    clientExecutable.preferResponseTypes(types);
                    continue block11;
                }
                case 7: {
                    Boolean prettyPrint = (Boolean)extraParameters.get((Object)PRETTY_PRINT);
                    if (!Boolean.TRUE.equals(prettyPrint)) continue block11;
                    clientExecutable.prettyPrint();
                    continue block11;
                }
                case 8: {
                    SummaryEnum summary = (SummaryEnum)extraParameters.get((Object)SUMMARY_ENUM);
                    clientExecutable.summaryMode(summary);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unsupported FHIR extra parameter parameter: " + String.valueOf((Object)entry.getKey()));
        }
    }
}

