/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.parser.IParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.camel.Exchange;
import org.apache.camel.component.fhir.FhirDataFormat;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirXmlDataFormat
extends FhirDataFormat {
    public void marshal(Exchange exchange, Object o, OutputStream outputStream) throws Exception {
        IBaseResource iBaseResource = !(o instanceof IBaseResource) ? (IBaseResource)exchange.getContext().getTypeConverter().mandatoryConvertTo(IBaseResource.class, exchange, o) : (IBaseResource)o;
        IParser parser = this.getFhirContext().newXmlParser();
        this.configureParser(parser);
        parser.encodeResourceToWriter(iBaseResource, (Writer)new OutputStreamWriter(outputStream));
        if (this.isContentTypeHeader()) {
            exchange.getMessage().setHeader("Content-Type", (Object)parser.getEncoding().getResourceContentTypeNonLegacy());
        }
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        IParser parser = this.getFhirContext().newXmlParser();
        this.configureParser(parser);
        return parser.parseResource((Reader)new InputStreamReader(inputStream));
    }

    public String getDataFormatName() {
        return "fhirXml";
    }
}

