/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.FhirMeta;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodArg;
import org.apache.camel.util.component.ApiMethodImpl;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IIdType;

public enum FhirMetaApiMethod implements ApiMethod
{
    ADD(IBaseMetaType.class, "add", ApiMethodArg.arg((String)"meta", IBaseMetaType.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    DELETE(IBaseMetaType.class, "delete", ApiMethodArg.arg((String)"meta", IBaseMetaType.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    GETFROMRESOURCE(IBaseMetaType.class, "getFromResource", ApiMethodArg.arg((String)"metaType", Class.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    GETFROMSERVER(IBaseMetaType.class, "getFromServer", ApiMethodArg.arg((String)"metaType", Class.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    GETFROMTYPE(IBaseMetaType.class, "getFromType", ApiMethodArg.arg((String)"metaType", Class.class), ApiMethodArg.arg((String)"theResourceName", String.class), ApiMethodArg.arg((String)"extraParameters", Map.class));

    private final ApiMethod apiMethod;

    private FhirMetaApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(FhirMeta.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

