
/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.fhir.api.FhirLoadPage;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.fhir.api.FhirLoadPage
 */
public enum FhirLoadPageApiMethod implements ApiMethod {

    BY_URL(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "byUrl",
        arg("url", String.class),
        arg("returnType", Class.class),
        arg("extraParameters", java.util.Map.class)),

    NEXT(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "next",
        arg("bundle", org.hl7.fhir.instance.model.api.IBaseBundle.class),
        arg("extraParameters", java.util.Map.class)),

    PREVIOUS(
        org.hl7.fhir.instance.model.api.IBaseBundle.class,
        "previous",
        arg("bundle", org.hl7.fhir.instance.model.api.IBaseBundle.class),
        arg("extraParameters", java.util.Map.class));

    private final ApiMethod apiMethod;

    private FhirLoadPageApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(FhirLoadPage.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
