/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.FhirEndpoint;
import org.apache.camel.component.fhir.internal.FhirApiName;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class FhirEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        FhirEndpoint target = (FhirEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                ((FhirConfiguration)target.getConfiguration()).setAccessToken((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold((Integer)FhirEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold((Integer)FhirEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier((Integer)FhirEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "client": {
                ((FhirConfiguration)target.getConfiguration()).setClient((IGenericClient)FhirEndpointConfigurer.property((CamelContext)camelContext, IGenericClient.class, (Object)value));
                return true;
            }
            case "clientfactory": 
            case "clientFactory": {
                ((FhirConfiguration)target.getConfiguration()).setClientFactory((IRestfulClientFactory)FhirEndpointConfigurer.property((CamelContext)camelContext, IRestfulClientFactory.class, (Object)value));
                return true;
            }
            case "compress": {
                ((FhirConfiguration)target.getConfiguration()).setCompress((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                ((FhirConfiguration)target.getConfiguration()).setConnectionTimeout((Integer)FhirEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                ((FhirConfiguration)target.getConfiguration()).setDeferModelScanning((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                target.setDelay((Long)FhirEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "encoding": {
                ((FhirConfiguration)target.getConfiguration()).setEncoding((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)FhirEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)FhirEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "fhircontext": 
            case "fhirContext": {
                ((FhirConfiguration)target.getConfiguration()).setFhirContext((FhirContext)FhirEndpointConfigurer.property((CamelContext)camelContext, FhirContext.class, (Object)value));
                return true;
            }
            case "fhirversion": 
            case "fhirVersion": {
                ((FhirConfiguration)target.getConfiguration()).setFhirVersion((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                ((FhirConfiguration)target.getConfiguration()).setForceConformanceCheck((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "greedy": {
                target.setGreedy((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "inbody": 
            case "inBody": {
                target.setInBody((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay((Long)FhirEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "log": {
                ((FhirConfiguration)target.getConfiguration()).setLog((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                ((FhirConfiguration)target.getConfiguration()).setPassword((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy((PollingConsumerPollStrategy)FhirEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "prettyprint": 
            case "prettyPrint": {
                ((FhirConfiguration)target.getConfiguration()).setPrettyPrint((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                ((FhirConfiguration)target.getConfiguration()).setProxyHost((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxypassword": 
            case "proxyPassword": {
                ((FhirConfiguration)target.getConfiguration()).setProxyPassword((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                ((FhirConfiguration)target.getConfiguration()).setProxyPort((Integer)FhirEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyuser": 
            case "proxyUser": {
                ((FhirConfiguration)target.getConfiguration()).setProxyUser((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount((Long)FhirEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel((LoggingLevel)FhirEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService((ScheduledExecutorService)FhirEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(FhirEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties((Map)FhirEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                ((FhirConfiguration)target.getConfiguration()).setServerUrl((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sessioncookie": 
            case "sessionCookie": {
                ((FhirConfiguration)target.getConfiguration()).setSessionCookie((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                ((FhirConfiguration)target.getConfiguration()).setSocketTimeout((Integer)FhirEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "summary": {
                ((FhirConfiguration)target.getConfiguration()).setSummary((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit((TimeUnit)((Object)FhirEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay((Boolean)FhirEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                ((FhirConfiguration)target.getConfiguration()).setUsername((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "validationmode": 
            case "validationMode": {
                ((FhirConfiguration)target.getConfiguration()).setValidationMode((String)FhirEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return String.class;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "client": {
                return IGenericClient.class;
            }
            case "clientfactory": 
            case "clientFactory": {
                return IRestfulClientFactory.class;
            }
            case "compress": {
                return Boolean.TYPE;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return Integer.class;
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                return Boolean.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "encoding": {
                return String.class;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "fhircontext": 
            case "fhirContext": {
                return FhirContext.class;
            }
            case "fhirversion": 
            case "fhirVersion": {
                return String.class;
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                return Boolean.TYPE;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "inbody": 
            case "inBody": {
                return String.class;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "log": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "prettyprint": 
            case "prettyPrint": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxypassword": 
            case "proxyPassword": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyuser": 
            case "proxyUser": {
                return String.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "sessioncookie": 
            case "sessionCookie": {
                return String.class;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return Integer.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "summary": {
                return String.class;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
            case "validationmode": 
            case "validationMode": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        FhirEndpoint target = (FhirEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return ((FhirConfiguration)target.getConfiguration()).getAccessToken();
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "client": {
                return ((FhirConfiguration)target.getConfiguration()).getClient();
            }
            case "clientfactory": 
            case "clientFactory": {
                return ((FhirConfiguration)target.getConfiguration()).getClientFactory();
            }
            case "compress": {
                return ((FhirConfiguration)target.getConfiguration()).isCompress();
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return ((FhirConfiguration)target.getConfiguration()).getConnectionTimeout();
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                return ((FhirConfiguration)target.getConfiguration()).isDeferModelScanning();
            }
            case "delay": {
                return target.getDelay();
            }
            case "encoding": {
                return ((FhirConfiguration)target.getConfiguration()).getEncoding();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "fhircontext": 
            case "fhirContext": {
                return ((FhirConfiguration)target.getConfiguration()).getFhirContext();
            }
            case "fhirversion": 
            case "fhirVersion": {
                return ((FhirConfiguration)target.getConfiguration()).getFhirVersion();
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                return ((FhirConfiguration)target.getConfiguration()).isForceConformanceCheck();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "inbody": 
            case "inBody": {
                return target.getInBody();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "log": {
                return ((FhirConfiguration)target.getConfiguration()).isLog();
            }
            case "password": {
                return ((FhirConfiguration)target.getConfiguration()).getPassword();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "prettyprint": 
            case "prettyPrint": {
                return ((FhirConfiguration)target.getConfiguration()).isPrettyPrint();
            }
            case "proxyhost": 
            case "proxyHost": {
                return ((FhirConfiguration)target.getConfiguration()).getProxyHost();
            }
            case "proxypassword": 
            case "proxyPassword": {
                return ((FhirConfiguration)target.getConfiguration()).getProxyPassword();
            }
            case "proxyport": 
            case "proxyPort": {
                return ((FhirConfiguration)target.getConfiguration()).getProxyPort();
            }
            case "proxyuser": 
            case "proxyUser": {
                return ((FhirConfiguration)target.getConfiguration()).getProxyUser();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "serverurl": 
            case "serverUrl": {
                return ((FhirConfiguration)target.getConfiguration()).getServerUrl();
            }
            case "sessioncookie": 
            case "sessionCookie": {
                return ((FhirConfiguration)target.getConfiguration()).getSessionCookie();
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return ((FhirConfiguration)target.getConfiguration()).getSocketTimeout();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "summary": {
                return ((FhirConfiguration)target.getConfiguration()).getSummary();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "username": {
                return ((FhirConfiguration)target.getConfiguration()).getUsername();
            }
            case "validationmode": 
            case "validationMode": {
                return ((FhirConfiguration)target.getConfiguration()).getValidationMode();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("ApiName", FhirApiName.class);
        map.put("MethodName", String.class);
        map.put("Encoding", String.class);
        map.put("FhirVersion", String.class);
        map.put("InBody", String.class);
        map.put("Log", Boolean.TYPE);
        map.put("PrettyPrint", Boolean.TYPE);
        map.put("ServerUrl", String.class);
        map.put("SendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("ExceptionHandler", ExceptionHandler.class);
        map.put("ExchangePattern", ExchangePattern.class);
        map.put("PollStrategy", PollingConsumerPollStrategy.class);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("Client", IGenericClient.class);
        map.put("ClientFactory", IRestfulClientFactory.class);
        map.put("Compress", Boolean.TYPE);
        map.put("ConnectionTimeout", Integer.class);
        map.put("DeferModelScanning", Boolean.TYPE);
        map.put("FhirContext", FhirContext.class);
        map.put("ForceConformanceCheck", Boolean.TYPE);
        map.put("SessionCookie", String.class);
        map.put("SocketTimeout", Integer.class);
        map.put("Summary", String.class);
        map.put("ValidationMode", String.class);
        map.put("ProxyHost", String.class);
        map.put("ProxyPassword", String.class);
        map.put("ProxyPort", Integer.class);
        map.put("ProxyUser", String.class);
        map.put("BackoffErrorThreshold", Integer.TYPE);
        map.put("BackoffIdleThreshold", Integer.TYPE);
        map.put("BackoffMultiplier", Integer.TYPE);
        map.put("Delay", Long.TYPE);
        map.put("Greedy", Boolean.TYPE);
        map.put("InitialDelay", Long.TYPE);
        map.put("RepeatCount", Long.TYPE);
        map.put("RunLoggingLevel", LoggingLevel.class);
        map.put("ScheduledExecutorService", ScheduledExecutorService.class);
        map.put("Scheduler", Object.class);
        map.put("SchedulerProperties", Map.class);
        map.put("StartScheduler", Boolean.TYPE);
        map.put("TimeUnit", TimeUnit.class);
        map.put("UseFixedDelay", Boolean.TYPE);
        map.put("AccessToken", String.class);
        map.put("Password", String.class);
        map.put("Username", String.class);
        ALL_OPTIONS = map;
    }
}

