/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.FhirTransaction;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.hl7.fhir.instance.model.api.IBaseBundle;

public enum FhirTransactionApiMethod implements ApiMethod
{
    WITH_BUNDLE(IBaseBundle.class, "withBundle", ApiMethodArg.arg((String)"bundle", IBaseBundle.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    WITH_BUNDLE_1(String.class, "withBundle", ApiMethodArg.arg((String)"stringBundle", String.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    WITH_RESOURCES(List.class, "withResources", ApiMethodArg.arg((String)"resources", List.class), ApiMethodArg.arg((String)"extraParameters", Map.class));

    private final ApiMethod apiMethod;

    private FhirTransactionApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(FhirTransaction.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

