/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import java.util.Map;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

@ApiParams(apiName="read", description="API method for read operations", apiMethods={@ApiMethod(methodName="resourceById", description="Reads a IBaseResource on the server by id", signatures={"org.hl7.fhir.instance.model.api.IBaseResource resourceById(Class<org.hl7.fhir.instance.model.api.IBaseResource> resource, org.hl7.fhir.instance.model.api.IIdType id, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceById(Class<org.hl7.fhir.instance.model.api.IBaseResource> resource, Long longId, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceById(String resourceClass, org.hl7.fhir.instance.model.api.IIdType id, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceById(String resourceClass, Long longId, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceById(Class<org.hl7.fhir.instance.model.api.IBaseResource> resource, String stringId, String version, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceById(String resourceClass, String stringId, String ifVersionMatches, String version, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="resourceByUrl", description="Reads a IBaseResource on the server by url", signatures={"org.hl7.fhir.instance.model.api.IBaseResource resourceByUrl(Class<org.hl7.fhir.instance.model.api.IBaseResource> resource, org.hl7.fhir.instance.model.api.IIdType iUrl, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceByUrl(Class<org.hl7.fhir.instance.model.api.IBaseResource> resource, String url, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceByUrl(String resourceClass, org.hl7.fhir.instance.model.api.IIdType iUrl, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "org.hl7.fhir.instance.model.api.IBaseResource resourceByUrl(String resourceClass, String url, String ifVersionMatches, Boolean returnNull, org.hl7.fhir.instance.model.api.IBaseResource returnResource, Boolean throwError, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class FhirReadEndpointConfiguration
extends FhirConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="resourceById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="resourceByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private Map<ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceByUrl", description="The IIdType referencing the resource by absolute url")})
    private IIdType iUrl;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceById", description="The IIdType referencing the resource")})
    private IIdType id;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="resourceById", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceById", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceById", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceById", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceById", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceById", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceByUrl", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceByUrl", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceByUrl", description="A version to match against the newest version on the server"), @ApiMethod(methodName="resourceByUrl", description="A version to match against the newest version on the server")})
    private String ifVersionMatches;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceById", description="The resource ID")})
    private Long longId;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceById", description="The resource to read (e.g. Patient)"), @ApiMethod(methodName="resourceByUrl", description="The resource to read (e.g. Patient)")})
    private Class<IBaseResource> resource;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceById", description="The resource to read (e.g. Patient)"), @ApiMethod(methodName="resourceByUrl", description="The resource to read (e.g. Patient.class)")})
    private String resourceClass;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="resourceById", description="Return null if version matches"), @ApiMethod(methodName="resourceById", description="Return null if version matches"), @ApiMethod(methodName="resourceById", description="Return null if version matches"), @ApiMethod(methodName="resourceById", description="Return null if version matches"), @ApiMethod(methodName="resourceById", description="Return null if version matches"), @ApiMethod(methodName="resourceById", description="Return null if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return null if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return null if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return null if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return null if version matches")})
    private Boolean returnNull;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="resourceById", description="Return the resource if version matches"), @ApiMethod(methodName="resourceById", description="Return the resource if version matches"), @ApiMethod(methodName="resourceById", description="Return the resource if version matches"), @ApiMethod(methodName="resourceById", description="Return the resource if version matches"), @ApiMethod(methodName="resourceById", description="Return the resource if version matches"), @ApiMethod(methodName="resourceById", description="Return the resource if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return the resource if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return the resource if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return the resource if version matches"), @ApiMethod(methodName="resourceByUrl", description="Return the resource if version matches")})
    private IBaseResource returnResource;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceById", description="The resource ID")})
    private String stringId;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="resourceById", description="Throw error if the version matches"), @ApiMethod(methodName="resourceById", description="Throw error if the version matches"), @ApiMethod(methodName="resourceById", description="Throw error if the version matches"), @ApiMethod(methodName="resourceById", description="Throw error if the version matches"), @ApiMethod(methodName="resourceById", description="Throw error if the version matches"), @ApiMethod(methodName="resourceById", description="Throw error if the version matches"), @ApiMethod(methodName="resourceByUrl", description="Throw error if the version matches"), @ApiMethod(methodName="resourceByUrl", description="Throw error if the version matches"), @ApiMethod(methodName="resourceByUrl", description="Throw error if the version matches"), @ApiMethod(methodName="resourceByUrl", description="Throw error if the version matches")})
    private Boolean throwError;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="resourceByUrl", description="Referencing the resource by absolute url")})
    private String url;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="resourceById", description="The resource version")})
    private String version;

    public Map<ExtraParameters, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public IIdType getIUrl() {
        return this.iUrl;
    }

    public void setIUrl(IIdType iUrl) {
        this.iUrl = iUrl;
    }

    public IIdType getId() {
        return this.id;
    }

    public void setId(IIdType id) {
        this.id = id;
    }

    public String getIfVersionMatches() {
        return this.ifVersionMatches;
    }

    public void setIfVersionMatches(String ifVersionMatches) {
        this.ifVersionMatches = ifVersionMatches;
    }

    public Long getLongId() {
        return this.longId;
    }

    public void setLongId(Long longId) {
        this.longId = longId;
    }

    public Class<IBaseResource> getResource() {
        return this.resource;
    }

    public void setResource(Class<IBaseResource> resource) {
        this.resource = resource;
    }

    public String getResourceClass() {
        return this.resourceClass;
    }

    public void setResourceClass(String resourceClass) {
        this.resourceClass = resourceClass;
    }

    public Boolean getReturnNull() {
        return this.returnNull;
    }

    public void setReturnNull(Boolean returnNull) {
        this.returnNull = returnNull;
    }

    public IBaseResource getReturnResource() {
        return this.returnResource;
    }

    public void setReturnResource(IBaseResource returnResource) {
        this.returnResource = returnResource;
    }

    public String getStringId() {
        return this.stringId;
    }

    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    public Boolean getThrowError() {
        return this.throwError;
    }

    public void setThrowError(Boolean throwError) {
        this.throwError = throwError;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

