/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileProducer<T>
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GenericFileProducer.class);
    protected final GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;
    private final Map<String, Lock> locks = Collections.synchronizedMap(LRUCacheFactory.newLRUCache((int)100));

    protected GenericFileProducer(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations) {
        super(endpoint);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String normalizePath(String name) {
        return FileUtil.normalizePath((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String existing = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        String target = this.createFileName(exchange);
        Lock lock = this.locks.computeIfAbsent(target, f -> new ReentrantLock());
        lock.lock();
        try {
            this.processExchange(exchange, target);
        }
        finally {
            lock.unlock();
            exchange.getIn().removeHeader("CamelOverruleFileName");
            exchange.getIn().setHeader("CamelFileName", (Object)existing);
        }
    }

    public void setOperations(GenericFileOperations<T> operations) {
        this.operations = operations;
    }

    protected void processExchange(Exchange exchange, String target) throws Exception {
        LOG.trace("Processing file: {} for exchange: {}", (Object)target, (Object)exchange);
        try {
            boolean targetExists;
            this.preWriteCheck(exchange);
            boolean writeAsTempAndRename = ObjectHelper.isNotEmpty((Object)this.endpoint.getTempFileName());
            String tempTarget = null;
            if (writeAsTempAndRename) {
                tempTarget = this.createTempFileName(exchange, target);
                LOG.trace("Writing using tempNameFile: {}", (Object)tempTarget);
                if (this.endpoint.getFileExist() != GenericFileExist.TryRename && this.endpoint.isEagerDeleteTargetFile() && (targetExists = this.operations.existsFile(target))) {
                    LOG.trace("EagerDeleteTargetFile, target exists");
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)target);
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Move) {
                        this.endpoint.getMoveExistingFileStrategy().moveExistingFile(this.endpoint, this.operations, target);
                    } else if (this.endpoint.isEagerDeleteTargetFile() && this.endpoint.getFileExist() == GenericFileExist.Override) {
                        LOG.trace("Eagerly deleting existing file: {}", (Object)target);
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                if (this.endpoint.getFileExist() != GenericFileExist.TryRename && this.operations.existsFile(tempTarget)) {
                    LOG.trace("Deleting existing temp file: {}", (Object)tempTarget);
                    if (!this.operations.deleteFile(tempTarget)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + tempTarget);
                    }
                }
            }
            this.writeFile(exchange, tempTarget != null ? tempTarget : target);
            if (tempTarget != null) {
                if (this.endpoint.getFileExist() != GenericFileExist.TryRename && !this.endpoint.isEagerDeleteTargetFile() && (targetExists = this.operations.existsFile(target))) {
                    LOG.trace("Not using EagerDeleteTargetFile, target exists");
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)target);
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Override) {
                        LOG.trace("Deleting existing file: {}", (Object)target);
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                LOG.trace("Renaming file: [{}] to: [{}]", (Object)tempTarget, (Object)target);
                boolean renamed = this.operations.renameFile(tempTarget, target);
                if (!renamed) {
                    throw new GenericFileOperationFailedException("Cannot rename file from: " + tempTarget + " to: " + target);
                }
            }
            if (this.endpoint.getDoneFileName() != null) {
                String doneFileName = this.endpoint.createDoneFileName(target);
                StringHelper.notEmpty((String)doneFileName, (String)"doneFileName", this.endpoint);
                DefaultExchange empty = new DefaultExchange(exchange);
                empty.getIn().setBody((Object)"");
                LOG.trace("Writing done file: [{}]", (Object)doneFileName);
                if (this.operations.existsFile(doneFileName) && !this.operations.deleteFile(doneFileName)) {
                    throw new GenericFileOperationFailedException("Cannot delete existing done file: " + doneFileName);
                }
                this.writeFile((Exchange)empty, doneFileName);
            }
            exchange.getIn().setHeader("CamelFileNameProduced", (Object)target);
        }
        catch (Exception e) {
            this.handleFailedWrite(exchange, e);
        }
        this.postWriteCheck(exchange);
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        throw exception;
    }

    public void preWriteCheck(Exchange exchange) throws Exception {
    }

    public void postWriteCheck(Exchange exchange) {
    }

    public void writeFile(Exchange exchange, String fileName) throws GenericFileOperationFailedException {
        boolean success;
        if (this.endpoint.isAutoCreate()) {
            String name = FileUtil.normalizePath((String)fileName);
            File file = new File(name);
            String directory = file.getParent();
            boolean absolute = FileUtil.isAbsolute((File)file);
            if (directory != null && !this.operations.buildDirectory(directory, absolute)) {
                LOG.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("About to write [{}] to [{}] from exchange [{}]", new Object[]{fileName, this.getEndpoint(), exchange});
        }
        if (!(success = this.operations.storeFile(fileName, exchange, -1L))) {
            throw new GenericFileOperationFailedException("Error writing file [" + fileName + "]");
        }
        LOG.debug("Wrote [{}] to [{}]", (Object)fileName, (Object)this.getEndpoint());
    }

    public String createFileName(Exchange exchange) {
        String compatchBaseDir;
        String compatchAnswer;
        int pos;
        String name;
        Object overrule = exchange.getIn().getHeader("CamelOverruleFileName");
        Object value = overrule != null ? (overrule instanceof Expression ? overrule : exchange.getContext().getTypeConverter().convertTo(String.class, exchange, overrule)) : exchange.getIn().getHeader("CamelFileName");
        if (overrule != null) {
            exchange.getIn().setHeader("CamelFileName", value);
        }
        if (value instanceof String && StringHelper.hasStartToken((String)((String)value), (String)"simple")) {
            LOG.warn("Simple expression: {} detected in header: {} of type String. This feature has been removed (see CAMEL-6748).", value, (Object)"CamelFileName");
        }
        Expression expression = this.endpoint.getFileName();
        if (value instanceof Expression) {
            expression = (Expression)value;
        }
        if (expression != null) {
            LOG.trace("Filename evaluated as expression: {}", (Object)expression);
            name = (String)expression.evaluate(exchange, String.class);
        } else {
            name = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
        }
        if (name != null && this.endpoint.isFlatten() && (pos = Math.max(name.lastIndexOf(47), name.lastIndexOf("\\"))) != -1) {
            name = name.substring(pos + 1);
        }
        String endpointPath = this.endpoint.getConfiguration().getDirectory();
        String baseDir = "";
        if (endpointPath.length() > 0) {
            boolean trailingSlash;
            baseDir = endpointPath;
            boolean bl = trailingSlash = endpointPath.endsWith("/") || endpointPath.endsWith("\\");
            if (!trailingSlash) {
                baseDir = baseDir + this.getFileSeparator();
            }
        }
        String answer = name != null ? baseDir + name : baseDir + this.endpoint.getGeneratedFileName(exchange.getIn());
        if (this.endpoint.isJailStartingDirectory() && !(compatchAnswer = FileUtil.compactPath((String)answer)).startsWith(compatchBaseDir = FileUtil.compactPath((String)baseDir))) {
            throw new IllegalArgumentException("Cannot write file with name: " + compatchAnswer + " as the filename is jailed to the starting directory: " + compatchBaseDir);
        }
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        return answer;
    }

    public String createTempFileName(Exchange exchange, String fileName) {
        String tempName;
        String answer = fileName;
        if (exchange.getIn().getHeader("CamelFileName") == null) {
            exchange.getIn().setHeader("CamelFileName", (Object)FileUtil.stripPath((String)fileName));
            tempName = (String)this.endpoint.getTempFileName().evaluate(exchange, String.class);
            exchange.getIn().removeHeader("CamelFileName");
        } else {
            tempName = (String)this.endpoint.getTempFileName().evaluate(exchange, String.class);
        }
        int pos = Math.max(answer.lastIndexOf(47), answer.lastIndexOf("\\"));
        if (pos == -1) {
            answer = tempName;
        } else {
            StringBuilder sb = new StringBuilder(answer.substring(0, pos + 1));
            sb.append(tempName);
            answer = sb.toString();
        }
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        answer = FileUtil.compactPath((String)answer, (String)this.getFileSeparator());
        return answer;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService(this.locks);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        ServiceHelper.stopService(this.locks);
    }
}

