/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.consumer.adapters;

import java.io.File;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.consumer.FileOffsetResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.AbstractFileResumeAdapter;
import org.apache.camel.component.file.consumer.adapters.FileOffset;
import org.apache.camel.resume.Offset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultFileOffsetResumeAdapter
extends AbstractFileResumeAdapter
implements FileOffsetResumeAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFileOffsetResumeAdapter.class);
    private GenericFile<File> genericFile;

    DefaultFileOffsetResumeAdapter() {
    }

    private Offset<?> getLastOffset(File addressable) {
        return (Offset)this.cache.get((Object)addressable, Offset.class);
    }

    @Override
    public void setResumePayload(GenericFile<File> genericFile) {
        assert (genericFile != null);
        this.genericFile = genericFile;
    }

    @Override
    public boolean add(Object key, Object offset) {
        if (!(offset instanceof Long)) {
            throw new UnsupportedOperationException("This adapter cannot be used for directory entries");
        }
        FileOffset fileOffset = (FileOffset)this.cache.computeIfAbsent((Object)((File)key), k -> new FileOffset());
        fileOffset.update((Long)offset);
        return true;
    }

    private void resumeFileOffsets() {
        if (this.genericFile == null) {
            return;
        }
        Offset<?> lastOffset = this.getLastOffset(this.genericFile.getFile());
        if (lastOffset == null) {
            return;
        }
        Object offsetObj = lastOffset.getValue();
        if (offsetObj == null) {
            return;
        }
        if (offsetObj instanceof Long) {
            this.genericFile.updateLastOffsetValue((Long)offsetObj);
        } else {
            LOG.warn("Cannot perform a resume operation of an object of unhandled type: {}", offsetObj.getClass());
        }
    }

    public void resume() {
        this.resumeFileOffsets();
    }

    public void deserializeFileOffset(File keyObj, Long valueObj) {
        FileOffset longOffset = (FileOffset)this.cache.computeIfAbsent((Object)keyObj, obj -> new FileOffset());
        longOffset.update(valueObj);
    }
}

