/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedExclusiveReadLockStrategy
extends MarkerFileExclusiveReadLockStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 1000L;
    private long minLength = 1L;
    private long minAge;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.DEBUG;

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (!super.acquireExclusiveReadLock(operations, file, exchange)) {
            return false;
        }
        File target = new File(file.getAbsoluteFilePath());
        boolean exclusive = false;
        LOG.trace("Waiting for exclusive read lock to file: {}", file);
        long lastModified = Long.MIN_VALUE;
        long length = Long.MIN_VALUE;
        StopWatch watch = new StopWatch();
        long startTime = new Date().getTime();
        while (!exclusive) {
            long delta;
            if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + file));
                return false;
            }
            if (!target.exists()) {
                CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock as file no longer exists. Will skip the file: " + file));
                return false;
            }
            long newLastModified = target.lastModified();
            long newLength = target.length();
            long newOlderThan = startTime + watch.taken() - this.minAge;
            LOG.trace("Previous last modified: {}, new last modified: {}", (Object)lastModified, (Object)newLastModified);
            LOG.trace("Previous length: {}, new length: {}", (Object)length, (Object)newLength);
            LOG.trace("New older than threshold: {}", (Object)newOlderThan);
            if (newLength >= this.minLength && (this.minAge == 0L && newLastModified == lastModified && newLength == length || this.minAge != 0L && newLastModified < newOlderThan)) {
                LOG.trace("Read lock acquired.");
                exclusive = true;
                continue;
            }
            lastModified = newLastModified;
            length = newLength;
            boolean interrupted = this.sleep();
            if (!interrupted) continue;
            return false;
        }
        return exclusive;
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", (Object)this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }
}

