/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategyFactory;
import org.apache.camel.component.file.remote.strategy.FtpChangedExclusiveReadLockStrategy;
import org.apache.camel.component.file.remote.strategy.StrategyUtil;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileNoOpProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenameProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileRenamer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.net.ftp.FTPFile;

public final class FtpProcessStrategyFactory
implements GenericFileProcessStrategyFactory<FTPFile> {
    public GenericFileProcessStrategy<FTPFile> createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isMove;
        Expression moveExpression = (Expression)params.get("move");
        Expression moveFailedExpression = (Expression)params.get("moveFailed");
        Expression preMoveExpression = (Expression)params.get("preMove");
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        boolean bl = isMove = moveExpression != null || preMoveExpression != null || moveFailedExpression != null;
        if (isDelete) {
            GenericFileExpressionRenamer renamer;
            GenericFileDeleteProcessStrategy strategy = new GenericFileDeleteProcessStrategy();
            strategy.setExclusiveReadLockStrategy(FtpProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer((GenericFileRenamer)renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer((GenericFileRenamer)renamer);
            }
            return strategy;
        }
        if (isMove || isNoop) {
            GenericFileExpressionRenamer renamer;
            GenericFileRenameProcessStrategy strategy = new GenericFileRenameProcessStrategy();
            strategy.setExclusiveReadLockStrategy(FtpProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (!isNoop && moveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveExpression);
                strategy.setCommitRenamer((GenericFileRenamer)renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer((GenericFileRenamer)renamer);
            }
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer((GenericFileRenamer)renamer);
            }
            return strategy;
        }
        GenericFileNoOpProcessStrategy strategy = new GenericFileNoOpProcessStrategy();
        strategy.setExclusiveReadLockStrategy(FtpProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        return strategy;
    }

    private static GenericFileExclusiveReadLockStrategy<FTPFile> getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy strategy = (GenericFileExclusiveReadLockStrategy)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty((String)readLock)) {
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("rename".equals(readLock)) {
                GenericFileRenameExclusiveReadLockStrategy readLockStrategy = new GenericFileRenameExclusiveReadLockStrategy();
                StrategyUtil.setup(readLockStrategy, params);
                return readLockStrategy;
            }
            if ("changed".equals(readLock)) {
                FtpChangedExclusiveReadLockStrategy readLockStrategy = new FtpChangedExclusiveReadLockStrategy();
                StrategyUtil.setup(readLockStrategy, params);
                return readLockStrategy;
            }
        }
        return null;
    }
}

