/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fury;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.fury.BaseFury;
import org.apache.fury.Fury;
import org.apache.fury.config.FuryBuilder;
import org.apache.fury.config.Language;
import org.apache.fury.io.FuryInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dataformat(value="fury")
@Metadata(firstVersion="4.9.0", title="Fury")
public class FuryDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(FuryDataFormat.class);
    private CamelContext camelContext;
    private Class<?> unmarshalType;
    private String unmarshalTypeName;
    private boolean requireClassRegistration = true;
    private boolean threadSafe = true;
    private boolean allowAutoWiredFury = true;
    private BaseFury fury;

    public FuryDataFormat() {
        this(Object.class);
    }

    public FuryDataFormat(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getDataFormatName() {
        return "fury";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        this.fury.serialize(stream, graph);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.fury.deserialize(new FuryInputStream(stream));
    }

    protected void doInit() throws Exception {
        if (this.unmarshalTypeName != null && (this.unmarshalType == null || this.unmarshalType == Object.class)) {
            this.unmarshalType = this.camelContext.getClassResolver().resolveClass(this.unmarshalTypeName);
        }
        if (this.fury == null && this.isAllowAutoWiredFury()) {
            this.fury = (BaseFury)this.getCamelContext().getRegistry().findSingleByType(BaseFury.class);
        }
        if (this.fury == null) {
            FuryBuilder builder = Fury.builder().withLanguage(Language.JAVA);
            builder.requireClassRegistration(this.requireClassRegistration);
            Object object = this.fury = this.threadSafe ? builder.buildThreadSafeFury() : builder.build();
        }
        if (this.unmarshalType != null) {
            this.fury.register(this.unmarshalType);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    public BaseFury getFury() {
        return this.fury;
    }

    public void setFury(BaseFury fury) {
        this.fury = fury;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public boolean isRequireClassRegistration() {
        return this.requireClassRegistration;
    }

    public void setRequireClassRegistration(boolean requireClassRegistration) {
        this.requireClassRegistration = requireClassRegistration;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }

    public boolean isAllowAutoWiredFury() {
        return this.allowAutoWiredFury;
    }

    public void setAllowAutoWiredFury(boolean allowAutoWiredFury) {
        this.allowAutoWiredFury = allowAutoWiredFury;
    }
}

