/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.mail;

import com.google.appengine.api.mail.MailService;
import org.apache.camel.Exchange;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.mail.GMailEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GMailBinding
implements OutboundBinding<GMailEndpoint, MailService.Message, Void> {
    public static final String GMAIL_SUBJECT = "org.apache.camel.component.gae.mail.Subject";
    public static final String GMAIL_TO = "org.apache.camel.component.gae.mail.To";

    @Override
    public MailService.Message writeRequest(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        MailService.Message message = new MailService.Message();
        this.writeFrom(endpoint, exchange, message);
        this.writeTo(endpoint, exchange, message);
        this.writeSubject(endpoint, exchange, message);
        this.writeBody(endpoint, exchange, message);
        this.writeAttachments(endpoint, exchange, message);
        return message;
    }

    @Override
    public Exchange readResponse(GMailEndpoint endpoint, Exchange exchange, Void response) {
        throw new UnsupportedOperationException("gmail responses not supported");
    }

    protected void writeFrom(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        request.setSender(endpoint.getSender());
    }

    protected void writeTo(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String to = (String)exchange.getIn().getHeader(GMAIL_TO);
        if (to == null) {
            to = endpoint.getTo();
        }
        request.setTo(new String[]{to});
    }

    protected void writeSubject(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        String subject = (String)exchange.getIn().getHeader(GMAIL_SUBJECT);
        if (subject == null) {
            subject = endpoint.getSubject();
        }
        request.setSubject(subject);
    }

    protected void writeBody(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
        request.setTextBody((String)exchange.getIn().getBody(String.class));
    }

    protected void writeAttachments(GMailEndpoint endpoint, Exchange exchange, MailService.Message request) {
    }
}

