/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.login;

import org.apache.camel.Exchange;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.login.GLoginData;
import org.apache.camel.component.gae.login.GLoginEndpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLoginBinding
implements OutboundBinding<GLoginEndpoint, GLoginData, GLoginData> {
    public static final String GLOGIN_HOST_NAME = "CamelGloginHostName";
    public static final String GLOGIN_USER_NAME = "CamelGloginUserName";
    public static final String GLOGIN_PASSWORD = "CamelGloginPassword";
    public static final String GLOGIN_TOKEN = "CamelGloginToken";
    public static final String GLOGIN_COOKIE = "CamelGloginCookie";

    @Override
    public GLoginData writeRequest(GLoginEndpoint endpoint, Exchange exchange, GLoginData request) {
        String hostName = (String)exchange.getIn().getHeader(GLOGIN_HOST_NAME, String.class);
        String userName = (String)exchange.getIn().getHeader(GLOGIN_USER_NAME, String.class);
        String password = (String)exchange.getIn().getHeader(GLOGIN_PASSWORD, String.class);
        request = new GLoginData();
        if (hostName == null) {
            hostName = endpoint.getHostName();
        }
        if (userName == null) {
            userName = endpoint.getUserName();
        }
        if (password == null) {
            password = endpoint.getPassword();
        }
        request.setClientName(endpoint.getClientName());
        request.setDevAdmin(endpoint.isDevAdmin());
        request.setDevPort(endpoint.getDevPort());
        request.setDevMode(endpoint.isDevMode());
        request.setHostName(hostName);
        request.setUserName(userName);
        request.setPassword(password);
        return request;
    }

    @Override
    public Exchange readResponse(GLoginEndpoint endpoint, Exchange exchange, GLoginData response) throws Exception {
        if (response.getAuthenticationToken() != null) {
            exchange.getOut().setHeader(GLOGIN_TOKEN, (Object)response.getAuthenticationToken());
        }
        if (response.getAuthorizationCookie() != null) {
            exchange.getOut().setHeader(GLOGIN_COOKIE, (Object)response.getAuthorizationCookie());
        }
        return exchange;
    }
}

