/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.login;

import com.google.gdata.client.GoogleAuthTokenFactory;
import com.google.gdata.util.AuthenticationException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.camel.component.gae.login.GLoginData;
import org.apache.camel.component.gae.login.GLoginService;

public class GLoginServiceImpl
implements GLoginService {
    public void authenticate(GLoginData data) throws AuthenticationException {
        if (data.isDevMode()) {
            return;
        }
        GoogleAuthTokenFactory factory = new GoogleAuthTokenFactory("ah", data.getClientName(), null);
        String token = factory.getAuthToken(data.getUserName(), data.getPassword(), null, null, "ah", data.getClientName());
        data.setAuthenticationToken(token);
    }

    public void authorize(GLoginData data) throws Exception {
        if (data.isDevMode()) {
            this.authorizeDev(data);
        } else {
            this.authorizeStd(data);
        }
    }

    protected void authorizeDev(GLoginData data) throws Exception {
        String homeLocation = String.format("http://%s:%d", data.getHostName(), data.getDevPort());
        HttpURLConnection connection = GLoginServiceImpl.createURLConnection(homeLocation + "/_ah/login", true);
        connection.connect();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(connection.getOutputStream()));
        writer.println(String.format("email=%s&isAdmin=%s&continue=%s", URLEncoder.encode(data.getUserName(), Charset.defaultCharset().name()), data.isDevAdmin() ? "on" : "off", URLEncoder.encode(homeLocation, Charset.defaultCharset().name())));
        writer.flush();
        data.setAuthorizationCookie(connection.getHeaderField("Set-Cookie"));
        connection.disconnect();
    }

    protected void authorizeStd(GLoginData data) throws Exception {
        String url = String.format("https://%s/_ah/login?auth=%s", data.getHostName(), data.getAuthenticationToken());
        HttpURLConnection connection = GLoginServiceImpl.createURLConnection(url, false);
        connection.connect();
        data.setAuthorizationCookie(connection.getHeaderField("Set-Cookie"));
        connection.disconnect();
    }

    private static HttpURLConnection createURLConnection(String url, boolean dev) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setInstanceFollowRedirects(false);
        if (dev) {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
        }
        return connection;
    }
}

