/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.http;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.gae.bind.InboundBinding;
import org.apache.camel.component.gae.bind.OutboundBinding;
import org.apache.camel.component.gae.http.GHttpEndpoint;
import org.apache.camel.component.gae.http.GHttpException;
import org.apache.camel.component.http.helper.GZIPHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public class GHttpBinding
implements OutboundBinding<GHttpEndpoint, HTTPRequest, HTTPResponse>,
InboundBinding<GHttpEndpoint, HttpServletRequest, HttpServletResponse> {
    @Override
    public Exchange readResponse(GHttpEndpoint endpoint, Exchange exchange, HTTPResponse response) throws Exception {
        int responseCode = response.getResponseCode();
        this.readResponseHeaders(endpoint, exchange, response);
        this.readResponseBody(endpoint, exchange, response);
        if (responseCode >= 400 && endpoint.isThrowExceptionOnFailure()) {
            throw new GHttpException(responseCode, (InputStream)exchange.getOut().getBody(InputStream.class), exchange.getOut().getHeaders());
        }
        return exchange;
    }

    @Override
    public HTTPRequest writeRequest(GHttpEndpoint endpoint, Exchange exchange, HTTPRequest request) throws Exception {
        HTTPRequest answer = new HTTPRequest(this.getRequestUrl(endpoint, exchange), this.getRequestMethod(endpoint, exchange));
        this.writeRequestHeaders(endpoint, exchange, answer);
        this.writeRequestBody(endpoint, exchange, answer);
        return answer;
    }

    @Override
    public Exchange readRequest(GHttpEndpoint endpoint, Exchange exchange, HttpServletRequest request) {
        this.readRequestHeaders(endpoint, exchange, request);
        return exchange;
    }

    @Override
    public HttpServletResponse writeResponse(GHttpEndpoint endpoint, Exchange exchange, HttpServletResponse response) {
        return response;
    }

    protected void readResponseHeaders(GHttpEndpoint endpoint, Exchange exchange, HTTPResponse response) {
        HeaderFilterStrategy strategy = endpoint.getHeaderFilterStrategy();
        Message in = exchange.getIn();
        Message out = exchange.getOut();
        out.setHeaders(in.getHeaders());
        out.setHeader("CamelHttpResponseCode", (Object)response.getResponseCode());
        String contentType = this.getResponseHeader("Content-Type", response);
        if (contentType != null) {
            out.setHeader("Content-Type", (Object)contentType);
        }
        for (HTTPHeader header : response.getHeaders()) {
            String name = header.getName();
            String value = header.getValue();
            if (strategy == null || strategy.applyFilterToExternalHeaders(name, (Object)value, exchange)) continue;
            out.setHeader(name, (Object)value);
        }
    }

    protected void readRequestHeaders(GHttpEndpoint endpoint, Exchange exchange, HttpServletRequest request) {
        exchange.getIn().removeHeader("Accept-Encoding");
        exchange.getIn().removeHeader("Content-Encoding");
    }

    protected void writeRequestHeaders(GHttpEndpoint endpoint, Exchange exchange, HTTPRequest request) {
        HeaderFilterStrategy strategy = endpoint.getHeaderFilterStrategy();
        for (String headerName : exchange.getIn().getHeaders().keySet()) {
            String headerValue = (String)exchange.getIn().getHeader(headerName, String.class);
            if (strategy == null || strategy.applyFilterToCamelHeaders(headerName, (Object)headerValue, exchange)) continue;
            request.addHeader(new HTTPHeader(headerName, headerValue));
        }
    }

    protected void readResponseBody(GHttpEndpoint endpoint, Exchange exchange, HTTPResponse response) throws Exception {
        byte[] content = response.getContent();
        if (content != null) {
            InputStream stream = new ByteArrayInputStream(content);
            if (GZIPHelper.isGzip((String)this.getResponseHeader("Content-Encoding", response))) {
                stream = new GZIPInputStream(stream);
            }
            exchange.getOut().setBody((Object)stream);
        }
    }

    protected void writeRequestBody(GHttpEndpoint endpoint, Exchange exchange, HTTPRequest request) {
        request.setPayload((byte[])exchange.getIn().getBody(byte[].class));
    }

    protected URL getRequestUrl(GHttpEndpoint endpoint, Exchange exchange) throws Exception {
        String uri = (String)exchange.getIn().getHeader("CamelHttpUri", String.class);
        String query = (String)exchange.getIn().getHeader("CamelHttpQuery", String.class);
        if (uri != null && !endpoint.isBridgeEndpoint()) {
            return GHttpEndpoint.getEndpointUrl(UnsafeUriCharactersEncoder.encode((String)uri), query);
        }
        return GHttpEndpoint.getEndpointUrl(endpoint.getEndpointUri(), query);
    }

    protected HTTPMethod getRequestMethod(GHttpEndpoint endpoint, Exchange exchange) {
        String method = (String)exchange.getIn().getHeader("CamelHttpMethod");
        if (method != null) {
            return HTTPMethod.valueOf((String)method);
        }
        if (exchange.getIn().getBody() != null) {
            return HTTPMethod.POST;
        }
        return HTTPMethod.GET;
    }

    protected String getResponseHeader(String name, HTTPResponse response) {
        for (HTTPHeader header : response.getHeaders()) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return null;
    }
}

