/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.gae.auth;

import com.google.gdata.client.authn.oauth.GoogleOAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import org.apache.camel.Exchange;
import org.apache.camel.component.gae.auth.GAuthEndpoint;
import org.apache.camel.component.gae.auth.GAuthTokenSecret;
import org.apache.camel.component.gae.bind.OutboundBinding;

public class GAuthAuthorizeBinding
implements OutboundBinding<GAuthEndpoint, GoogleOAuthParameters, GoogleOAuthParameters> {
    public static final String GAUTH_SCOPE = "CamelGauthScope";
    public static final String GAUTH_CALLBACK = "CamelGauthCallback";

    @Override
    public GoogleOAuthParameters writeRequest(GAuthEndpoint endpoint, Exchange exchange, GoogleOAuthParameters request) {
        String scope;
        String callback = (String)exchange.getIn().getHeader(GAUTH_CALLBACK, String.class);
        if (callback == null) {
            callback = endpoint.getCallback();
        }
        if ((scope = (String)exchange.getIn().getHeader(GAUTH_SCOPE, String.class)) == null) {
            scope = endpoint.getScope();
        }
        request = new GoogleOAuthParameters();
        request.setOAuthConsumerKey(endpoint.getConsumerKey());
        request.setOAuthConsumerSecret(endpoint.getConsumerSecret());
        request.setOAuthCallback(callback);
        request.setScope(scope);
        return request;
    }

    @Override
    public Exchange readResponse(GAuthEndpoint endpoint, Exchange exchange, GoogleOAuthParameters response) throws Exception {
        String authrUrl = endpoint.newOAuthHelper().createUserAuthorizationUrl((OAuthParameters)response);
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)302);
        exchange.getOut().setHeader("Location", (Object)authrUrl);
        if (endpoint.getComponent().getKeyLoader() == null) {
            String secret = response.getOAuthTokenSecret();
            String cookie = new GAuthTokenSecret(secret).toCookie();
            exchange.getOut().setHeader("Set-Cookie", (Object)cookie);
        }
        return exchange;
    }
}

